/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.zipfile.ZipIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

@Dataformat(value="zipFile")
public class ZipFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final long DEFAULT_MAXIMUM_DECOMPRESSED_SIZE = 0x40000000L;
    private boolean usingIterator;
    private boolean allowEmptyDirectory;
    private boolean preservePathElements;
    private long maxDecompressedSize = 0x40000000L;

    public String getDataFormatName() {
        return "zipFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Path filenamePath;
        String filename = null;
        String filepath = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        Long fileLength = (Long)exchange.getIn().getHeader("CamelFileLength", Long.class);
        if (filepath != null && (filenamePath = Paths.get(filepath, new String[0]).getFileName()) != null) {
            filename = filenamePath.toString();
        }
        if (filename == null) {
            filename = filepath = StringHelper.sanitize((String)exchange.getIn().getMessageId());
        }
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        if (fileLength == null) {
            fileLength = is.available();
        }
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(stream);
        if (this.preservePathElements) {
            this.createZipEntries(zos, filepath, fileLength);
        } else {
            this.createZipEntries(zos, filename, fileLength);
        }
        try {
            IOHelper.copy((InputStream)is, (OutputStream)zos);
        }
        catch (Throwable throwable) {
            zos.closeArchiveEntry();
            IOHelper.close((Closeable[])new Closeable[]{is, zos});
            throw throwable;
        }
        zos.closeArchiveEntry();
        IOHelper.close((Closeable[])new Closeable[]{is, zos});
        String newFilename = filename + ".zip";
        exchange.getMessage().setHeader("CamelFileName", (Object)newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        if (this.usingIterator) {
            ZipIterator zipIterator = new ZipIterator(exchange, inputStream);
            zipIterator.setAllowEmptyDirectory(this.allowEmptyDirectory);
            return zipIterator;
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ZipArchiveInputStream zis = (ZipArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)bis);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            ZipArchiveEntry entry = zis.getNextEntry();
            if (entry == null) {
                throw new IllegalStateException("Unable to unzip the file, it may be corrupted.");
            }
            exchange.getMessage().setHeader("CamelFileName", (Object)entry.getName());
            IOHelper.copy((InputStream)zis, (OutputStream)osb, (int)16384, (boolean)false, (long)this.maxDecompressedSize);
            entry = zis.getNextEntry();
            if (entry != null) {
                throw new IllegalStateException("Zip file has more than 1 entry.");
            }
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{osb, zis, bis});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{osb, zis, bis});
        return object;
    }

    private void createZipEntries(ZipArchiveOutputStream zos, String filepath, Long fileLength) throws IOException {
        Iterator<Path> elements = Paths.get(filepath, new String[0]).iterator();
        StringBuilder sb = new StringBuilder(256);
        while (elements.hasNext()) {
            Path path = elements.next();
            Object element = path.toString();
            Long length = fileLength;
            if (elements.hasNext()) {
                element = (String)element + "/";
                length = 0L;
            }
            ZipArchiveEntry entry = new ZipArchiveEntry(String.valueOf(sb) + (String)element);
            entry.setSize(length.longValue());
            zos.putArchiveEntry(entry);
            sb.append((String)element);
        }
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public boolean isAllowEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }

    public boolean isPreservePathElements() {
        return this.preservePathElements;
    }

    public void setPreservePathElements(boolean preservePathElements) {
        this.preservePathElements = preservePathElements;
    }

    public long getMaxDecompressedSize() {
        return this.maxDecompressedSize;
    }

    public void setMaxDecompressedSize(long maxDecompressedSize) {
        this.maxDecompressedSize = maxDecompressedSize;
    }
}

