/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.Exchange;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.model.ZeebeMessage;
import org.apache.camel.component.zeebe.processor.ZeebeProcessor;
import org.apache.camel.support.service.BaseService;

public abstract class AbstractBaseProcessor
extends BaseService
implements ZeebeProcessor {
    protected final ZeebeEndpoint endpoint;
    ObjectMapper objectMapper = new ObjectMapper();

    public AbstractBaseProcessor(ZeebeEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected void setBody(Exchange exchange, ZeebeMessage message, boolean formatJSON) {
        if (this.endpoint.isFormatJSON()) {
            try {
                exchange.getMessage().setBody((Object)this.objectMapper.writeValueAsString((Object)message));
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalArgumentException("Cannot convert result", jsonProcessingException);
            }
        } else {
            exchange.getMessage().setBody((Object)message);
        }
    }

    protected void removeHeaders(Exchange exchange) {
        exchange.getMessage().removeHeaders("CamelZeebe.*");
    }
}

