/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.yaml.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

class ModelJSonSchemaResolver
implements JSonSchemaResolver {
    private CatalogCamelContext camelContext;
    private ClassLoader classLoader;

    ModelJSonSchemaResolver() {
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = (CatalogCamelContext)camelContext;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getComponentJSonSchema(String name) {
        if (this.camelContext != null) {
            try {
                return this.camelContext.getComponentParameterJsonSchema(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getDataFormatJSonSchema(String name) {
        if (this.camelContext != null) {
            try {
                return this.camelContext.getDataFormatParameterJsonSchema(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLanguageJSonSchema(String name) {
        if (this.camelContext != null) {
            try {
                return this.camelContext.getLanguageParameterJsonSchema(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getTransformerJSonSchema(String name) {
        if (this.camelContext != null) {
            try {
                return this.camelContext.getTransformerParameterJsonSchema(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getDevConsoleJSonSchema(String name) {
        if (this.camelContext != null) {
            try {
                return this.camelContext.getDevConsoleParameterJsonSchema(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getOtherJSonSchema(String name) {
        return null;
    }

    public String getPojoBeanJSonSchema(String name) {
        if (this.camelContext != null) {
            try {
                return this.camelContext.getPojoBeanParameterJsonSchema(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getModelJSonSchema(String name) {
        try {
            String[] subPackages;
            for (String sub : subPackages = new String[]{"", "cloud/", "config/", "dataformat/", "errorhandler/", "language/", "loadbalancer/", "rest/", "transformer/", "validator/"}) {
                String path = "META-INF/org/apache/camel/model/" + sub + name + ".json";
                String data = this.doLoadResource(path);
                if (data == null) continue;
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getMainJsonSchema() {
        try {
            String path = "META-INF/camel-main-configuration-metadata.json";
            return this.doLoadResource(path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getJBangJsonSchema() {
        try {
            String path = "META-INF/camel-jbang-configuration-metadata.json";
            return this.doLoadResource(path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doLoadResource(String path) throws IOException {
        InputStream is = null;
        if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(path);
        }
        if (is == null && this.camelContext != null) {
            ClassResolver resolver = this.camelContext.getClassResolver();
            is = resolver.loadResourceAsStream(path);
        }
        if (is == null) {
            is = ObjectHelper.loadResourceAsStream((String)path, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        if (is != null) {
            try {
                String string = IOHelper.loadText((InputStream)is);
                return string;
            }
            catch (IOException iOException) {
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return null;
    }
}

