/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.xslt.DefaultTransformErrorHandler;
import org.apache.camel.component.xslt.DomResultHandlerFactory;
import org.apache.camel.component.xslt.FileResultHandlerFactory;
import org.apache.camel.component.xslt.ResultHandler;
import org.apache.camel.component.xslt.ResultHandlerFactory;
import org.apache.camel.component.xslt.SourceHandlerFactory;
import org.apache.camel.component.xslt.StreamResultHandlerFactory;
import org.apache.camel.component.xslt.StringResultHandlerFactory;
import org.apache.camel.component.xslt.XmlSourceHandlerFactoryImpl;
import org.apache.camel.component.xslt.XsltErrorListener;
import org.apache.camel.component.xslt.XsltUriResolver;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.builder.xml.StAX2SAXSource;
import org.apache.camel.support.builder.xml.XMLConverterHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class XsltBuilder
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(XsltBuilder.class);
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private XMLConverterHelper converter = new XMLConverterHelper();
    private Templates template;
    private volatile BlockingQueue<Transformer> transformers;
    private SourceHandlerFactory sourceHandlerFactory;
    private ResultHandlerFactory resultHandlerFactory = new StringResultHandlerFactory();
    private boolean failOnNullBody = true;
    private URIResolver uriResolver;
    private boolean deleteOutputFile;
    private ErrorListener errorListener;
    private boolean allowStAX = true;
    private EntityResolver entityResolver;
    private volatile Object sourceHandlerFactoryLock = new Object();

    public XsltBuilder() {
    }

    public XsltBuilder(Templates templates) {
        this.template = templates;
    }

    public String toString() {
        return "XSLT[" + this.template + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull((Object)this.getTemplate(), (String)"template");
        if (this.isDeleteOutputFile()) {
            String fileName = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelXsltFileName", String.class);
            exchange.addOnCompletion((Synchronization)new XsltBuilderOnCompletion(fileName));
        }
        Transformer transformer = this.getTransformer();
        this.configureTransformer(transformer, exchange);
        ResultHandler resultHandler = this.resultHandlerFactory.createResult(exchange);
        Result result = resultHandler.getResult();
        Message out = exchange.getOut();
        out.copyFrom(exchange.getIn());
        Closeable is = null;
        try {
            Source source = this.getSourceHandlerFactory().getSource(exchange);
            if (!this.isAllowStAX() && source instanceof StAXSource) {
                source = new StAX2SAXSource(((StAXSource)source).getXMLStreamReader());
            }
            if (source instanceof SAXSource) {
                this.tryAddEntityResolver((SAXSource)source);
            }
            LOG.trace("Using {} as source", (Object)source);
            transformer.transform(source, result);
            LOG.trace("Transform complete with result {}", (Object)result);
            resultHandler.setBody(out);
        }
        finally {
            this.releaseTransformer(transformer);
            IOHelper.close(is);
        }
    }

    public static XsltBuilder xslt(Templates templates) {
        return new XsltBuilder(templates);
    }

    public static XsltBuilder xslt(Source xslt) throws TransformerConfigurationException {
        ObjectHelper.notNull((Object)xslt, (String)"xslt");
        XsltBuilder answer = new XsltBuilder();
        answer.setTransformerSource(xslt);
        return answer;
    }

    public static XsltBuilder xslt(File xslt) throws TransformerConfigurationException {
        ObjectHelper.notNull((Object)xslt, (String)"xslt");
        return XsltBuilder.xslt(new StreamSource(xslt));
    }

    public static XsltBuilder xslt(URL xslt) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull((Object)xslt, (String)"xslt");
        return XsltBuilder.xslt(xslt.openStream());
    }

    public static XsltBuilder xslt(InputStream xslt) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull((Object)xslt, (String)"xslt");
        return XsltBuilder.xslt(new StreamSource(xslt));
    }

    public XsltBuilder outputBytes() {
        this.setResultHandlerFactory(new StreamResultHandlerFactory());
        return this;
    }

    public XsltBuilder outputString() {
        this.setResultHandlerFactory(new StringResultHandlerFactory());
        return this;
    }

    public XsltBuilder outputDOM() {
        this.setResultHandlerFactory(new DomResultHandlerFactory());
        return this;
    }

    public XsltBuilder outputFile() {
        this.setResultHandlerFactory(new FileResultHandlerFactory());
        return this;
    }

    public XsltBuilder deleteOutputFile() {
        this.deleteOutputFile = true;
        return this;
    }

    public XsltBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public XsltBuilder uriResolver(URIResolver uriResolver) {
        this.setUriResolver(uriResolver);
        return this;
    }

    public XsltBuilder allowStAX() {
        this.setAllowStAX(true);
        return this;
    }

    public XsltBuilder transformerCacheSize(int numberToCache) {
        this.transformers = numberToCache > 0 ? new ArrayBlockingQueue<Transformer>(numberToCache) : null;
        return this;
    }

    public XsltBuilder errorListener(ErrorListener errorListener) {
        this.setErrorListener(errorListener);
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setTemplate(Templates template) {
        this.template = template;
        if (this.transformers != null) {
            this.transformers.clear();
        }
    }

    public Templates getTemplate() {
        return this.template;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceHandlerFactory getSourceHandlerFactory() {
        if (this.sourceHandlerFactory == null) {
            Object object = this.sourceHandlerFactoryLock;
            synchronized (object) {
                if (this.sourceHandlerFactory == null) {
                    XmlSourceHandlerFactoryImpl xmlSourceHandlerFactory = new XmlSourceHandlerFactoryImpl();
                    xmlSourceHandlerFactory.setFailOnNullBody(this.isFailOnNullBody());
                    xmlSourceHandlerFactory.setAllowStax(this.isAllowStAX());
                    this.sourceHandlerFactory = xmlSourceHandlerFactory;
                }
            }
        }
        return this.sourceHandlerFactory;
    }

    public void setSourceHandlerFactory(SourceHandlerFactory sourceHandlerFactory) {
        this.sourceHandlerFactory = sourceHandlerFactory;
    }

    public ResultHandlerFactory getResultHandlerFactory() {
        return this.resultHandlerFactory;
    }

    public void setResultHandlerFactory(ResultHandlerFactory resultHandlerFactory) {
        this.resultHandlerFactory = resultHandlerFactory;
    }

    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    public void setTransformerSource(Source source) throws TransformerConfigurationException {
        Templates templates;
        TransformerFactory factory = this.converter.getTransformerFactory();
        if (this.errorListener != null) {
            factory.setErrorListener(this.errorListener);
        } else {
            factory.setErrorListener(new XsltErrorListener());
        }
        if (this.getUriResolver() != null) {
            factory.setURIResolver(this.getUriResolver());
        }
        if ((templates = factory.newTemplates(source)) == null) {
            throw new TransformerConfigurationException("Error creating XSLT template. This is most likely be caused by a XML parse error. Please verify your XSLT file configured.");
        }
        this.setTemplate(templates);
    }

    public void setTransformerFile(File xslt) throws TransformerConfigurationException {
        this.setTransformerSource(new StreamSource(xslt));
    }

    public void setTransformerURL(URL url) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull((Object)url, (String)"url");
        this.setTransformerInputStream(url.openStream());
    }

    public void setTransformerInputStream(InputStream in) throws TransformerConfigurationException, IOException {
        ObjectHelper.notNull((Object)in, (String)"InputStream");
        this.setTransformerSource(new StreamSource(in));
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public boolean isDeleteOutputFile() {
        return this.deleteOutputFile;
    }

    public void setDeleteOutputFile(boolean deleteOutputFile) {
        this.deleteOutputFile = deleteOutputFile;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.converter.setTransformerFactory(transformerFactory);
    }

    private void releaseTransformer(Transformer transformer) {
        if (this.transformers != null) {
            transformer.reset();
            this.transformers.offer(transformer);
        }
    }

    private Transformer getTransformer() throws Exception {
        Transformer t = null;
        if (this.transformers != null) {
            t = (Transformer)this.transformers.poll();
        }
        if (t == null) {
            t = this.createTransformer();
        }
        return t;
    }

    protected Transformer createTransformer() throws Exception {
        return this.getTemplate().newTransformer();
    }

    private void tryAddEntityResolver(SAXSource source) {
        if (this.entityResolver != null && source != null) {
            source.getXMLReader().setEntityResolver(this.entityResolver);
        }
    }

    protected void configureTransformer(Transformer transformer, Exchange exchange) throws Exception {
        if (this.uriResolver == null) {
            this.uriResolver = new XsltUriResolver(exchange.getContext(), null);
        }
        transformer.setURIResolver(this.uriResolver);
        if (this.errorListener == null) {
            transformer.setErrorListener(new DefaultTransformErrorHandler(exchange));
        } else {
            transformer.setErrorListener(this.errorListener);
        }
        transformer.clearParameters();
        this.addParameters(transformer, exchange.getProperties());
        this.addParameters(transformer, exchange.getIn().getHeaders());
        this.addParameters(transformer, this.getParameters());
        transformer.setParameter("exchange", exchange);
        transformer.setParameter("in", exchange.getIn());
        transformer.setParameter("out", exchange.getOut());
    }

    protected void addParameters(Transformer transformer, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            LOG.trace("Transformer set parameter {} -> {}", (Object)key, value);
            transformer.setParameter(key, value);
        }
    }

    private static final class XsltBuilderOnCompletion
    extends SynchronizationAdapter {
        private final String fileName;

        private XsltBuilderOnCompletion(String fileName) {
            this.fileName = fileName;
        }

        public void onDone(Exchange exchange) {
            FileUtil.deleteFile((File)new File(this.fileName));
        }

        public String toString() {
            return "XsltBuilderOnCompletion";
        }
    }
}

