/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppComponent
extends DefaultComponent<XmppExchange>
implements HeaderFilterStrategyAware {
    private HeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();

    public XmppComponent() {
    }

    public XmppComponent(CamelContext context) {
        super(context);
    }

    public static XmppComponent xmppComponent() {
        return new XmppComponent();
    }

    protected Endpoint<XmppExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String remainingPath;
        XmppEndpoint endpoint = new XmppEndpoint(uri, this);
        URI u = new URI(uri);
        endpoint.setHost(u.getHost());
        endpoint.setPort(u.getPort());
        if (u.getUserInfo() != null) {
            endpoint.setUser(u.getUserInfo());
        }
        if ((remainingPath = u.getPath()) != null) {
            if (remainingPath.startsWith("/")) {
                remainingPath = remainingPath.substring(1);
            }
            if (remainingPath.length() > 0) {
                endpoint.setParticipant(remainingPath);
            }
        }
        return endpoint;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

