/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmpp.RuntimeXmppException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class XmppPrivateChatProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(XmppPrivateChatProducer.class);
    private final XmppEndpoint endpoint;
    private final String participant;
    private Chat chat;

    public XmppPrivateChatProducer(XmppEndpoint endpoint, String participant) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.participant = participant;
        if (participant == null) {
            throw new IllegalArgumentException("No participant property specified");
        }
    }

    public void process(Exchange exchange) {
        Message message = this.chat.createMessage();
        message.setTo(this.participant);
        message.setThread(exchange.getExchangeId());
        this.endpoint.getBinding().populateXmppMessage(message, exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>>> message: " + message.getBody()));
        }
        try {
            this.chat.sendMessage(message);
        }
        catch (XMPPException e) {
            throw new RuntimeXmppException(e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.chat == null) {
            this.chat = this.endpoint.getConnection().createChat(this.getParticipant());
        }
    }

    protected void doStop() throws Exception {
        this.chat = null;
        super.doStop();
    }

    public Chat getChat() {
        return this.chat;
    }

    public void setChat(Chat chat) {
        this.chat = chat;
    }

    public String getParticipant() {
        return this.participant;
    }
}

