/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class XMLStreamReaderReader
extends Reader {
    private static final int BUFFER_SIZE = 4096;
    private final XMLStreamReader reader;
    private XMLStreamWriter writer;
    private final TrimmableCharArrayWriter chunk;
    private final char[] buffer;
    private int bpos;

    XMLStreamReaderReader(XMLStreamReader reader, XMLOutputFactory outfactory) {
        this.reader = reader;
        this.buffer = new char[4096];
        this.chunk = new TrimmableCharArrayWriter();
        try {
            this.writer = outfactory.createXMLStreamWriter(this.chunk);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n;
        int tlen = 0;
        while (len > 0 && (n = this.ensureBuffering(len)) >= 0) {
            int clen = Math.min(len, n);
            System.arraycopy(this.buffer, 0, cbuf, off, clen);
            System.arraycopy(this.buffer, clen, this.buffer, 0, this.buffer.length - clen);
            this.bpos -= clen;
            len -= clen;
            off += clen;
            tlen += clen;
        }
        return tlen > 0 ? tlen : -1;
    }

    private int ensureBuffering(int size) throws IOException {
        if (size < this.bpos) {
            return this.bpos;
        }
        try {
            int csize;
            if (7 == this.reader.getEventType()) {
                this.writer.writeStartDocument("utf-8", "1.0");
            }
            if (this.chunk.size() < this.buffer.length) {
                while (this.reader.hasNext()) {
                    int code = this.reader.next();
                    switch (code) {
                        case 8: {
                            this.writer.writeEndDocument();
                            break;
                        }
                        case 1: {
                            int i;
                            QName qname = this.reader.getName();
                            this.writer.writeStartElement(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
                            for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                                this.writer.writeAttribute(this.reader.getAttributePrefix(i), this.reader.getAttributeNamespace(i), this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
                            }
                            for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                                this.writer.writeNamespace(this.reader.getNamespacePrefix(i), this.reader.getNamespaceURI(i));
                            }
                            break;
                        }
                        case 2: {
                            this.writer.writeEndElement();
                            break;
                        }
                        case 4: {
                            this.writer.writeCharacters(this.reader.getText());
                            break;
                        }
                        case 5: {
                            this.writer.writeComment(this.reader.getText());
                            break;
                        }
                        case 12: {
                            this.writer.writeCData(this.reader.getText());
                            break;
                        }
                    }
                    int csize2 = this.buffer.length - this.bpos;
                    if (this.chunk.size() <= csize2) continue;
                    System.arraycopy(this.chunk.getCharArray(), 0, this.buffer, this.bpos, csize2);
                    this.bpos = this.buffer.length;
                    this.chunk.trim(csize2, 0);
                    return this.buffer.length;
                }
            }
            if ((csize = Math.min(this.chunk.size(), this.buffer.length - this.bpos)) > 0) {
                System.arraycopy(this.chunk.getCharArray(), 0, this.buffer, this.bpos, csize);
                this.bpos += csize;
                this.chunk.trim(csize, 0);
                return this.bpos;
            }
            return this.bpos > 0 ? this.bpos : -1;
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    static class TrimmableCharArrayWriter
    extends CharArrayWriter {
        TrimmableCharArrayWriter() {
        }

        public void trim(int head, int tail) {
            System.arraycopy(this.buf, head, this.buf, 0, this.count - head - tail);
            this.count -= head + tail;
        }

        public char[] toCharArray(int len) {
            char[] c = new char[len];
            System.arraycopy(this.buf, 0, c, 0, len);
            return c;
        }

        char[] getCharArray() {
            return this.buf;
        }
    }
}

