/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor.validation;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.ValidationException;
import org.xml.sax.SAXParseException;

public class SchemaValidationException
extends ValidationException {
    private static final long serialVersionUID = 2656907296674888684L;
    private final Object schema;
    private final List<SAXParseException> fatalErrors;
    private final List<SAXParseException> errors;
    private final List<SAXParseException> warnings;

    public SchemaValidationException(Exchange exchange, Object schema, List<SAXParseException> fatalErrors, List<SAXParseException> errors, List<SAXParseException> warnings) {
        super(exchange, SchemaValidationException.message(schema, fatalErrors, errors, warnings));
        this.schema = schema;
        this.fatalErrors = fatalErrors;
        this.errors = errors;
        this.warnings = warnings;
    }

    public Object getSchema() {
        return this.schema;
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<SAXParseException> getFatalErrors() {
        return this.fatalErrors;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    protected static String message(Object schema, List<SAXParseException> fatalErrors, List<SAXParseException> errors, List<SAXParseException> warnings) {
        StringBuilder buffer = new StringBuilder(128).append("Validation failed for: ").append(schema).append("\n");
        if (!fatalErrors.isEmpty()) {
            buffer.append("fatal errors: [").append("\n");
            SchemaValidationException.appendDetails(buffer, fatalErrors);
            buffer.append("]").append("\n");
        }
        if (!errors.isEmpty()) {
            buffer.append("errors: [").append("\n");
            SchemaValidationException.appendDetails(buffer, errors);
            buffer.append("]");
        }
        return buffer.toString();
    }

    private static void appendDetails(StringBuilder buffer, List<SAXParseException> saxParseExceptions) {
        for (SAXParseException e : saxParseExceptions) {
            buffer.append(e.getClass().getName()).append(": ");
            buffer.append(e.getMessage()).append(", ");
            buffer.append("Line : ").append(e.getLineNumber()).append(", ");
            buffer.append("Column : ").append(e.getColumnNumber()).append("\n");
        }
    }
}

