/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class StAX2SAXSource
extends SAXSource
implements XMLReader {
    private final XMLStreamReader streamReader;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    public StAX2SAXSource(XMLStreamReader streamReader) {
        this.streamReader = streamReader;
        this.setInputSource(new InputSource());
    }

    @Override
    public XMLReader getXMLReader() {
        return this;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.streamReader;
    }

    protected void parse() throws SAXException {
        StAX2SAXAttributes attributes = new StAX2SAXAttributes();
        try {
            while (true) {
                switch (this.streamReader.getEventType()) {
                    case 10: {
                        break;
                    }
                    case 12: {
                        if (this.lexicalHandler != null) {
                            this.lexicalHandler.startCDATA();
                        }
                        int length = this.streamReader.getTextLength();
                        int start = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.characters(chars, start, length);
                        if (this.lexicalHandler == null) break;
                        this.lexicalHandler.endCDATA();
                        break;
                    }
                    case 4: {
                        int length = this.streamReader.getTextLength();
                        int start = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.characters(chars, start, length);
                        break;
                    }
                    case 6: {
                        int length = this.streamReader.getTextLength();
                        int start = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.ignorableWhitespace(chars, start, length);
                        break;
                    }
                    case 5: {
                        if (this.lexicalHandler == null) break;
                        int length = this.streamReader.getTextLength();
                        int start = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.lexicalHandler.comment(chars, start, length);
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 8: {
                        this.contentHandler.endDocument();
                        return;
                    }
                    case 2: {
                        String uri = this.nullToEmpty(this.streamReader.getNamespaceURI());
                        String localName = this.streamReader.getLocalName();
                        String qname = this.getPrefixedName(this.streamReader.getPrefix(), localName);
                        this.contentHandler.endElement(uri, localName, qname);
                        for (int i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
                            String nsPrefix = this.streamReader.getNamespacePrefix(i);
                            this.contentHandler.endPrefixMapping(nsPrefix);
                        }
                        break;
                    }
                    case 9: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 7: {
                        this.contentHandler.startDocument();
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
                            String nsPrefix = this.nullToEmpty(this.streamReader.getNamespacePrefix(i));
                            String nsUri = this.nullToEmpty(this.streamReader.getNamespaceURI(i));
                            this.contentHandler.startPrefixMapping(nsPrefix, nsUri);
                        }
                        String uri = this.nullToEmpty(this.streamReader.getNamespaceURI());
                        String localName = this.streamReader.getLocalName();
                        String qname = this.getPrefixedName(this.streamReader.getPrefix(), localName);
                        attributes.init();
                        this.contentHandler.startElement(uri, localName, qname, attributes);
                        attributes.reset();
                        break;
                    }
                }
                if (!this.streamReader.hasNext()) {
                    return;
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException e) {
            SAXParseException spe = e.getLocation() != null ? new SAXParseException(e.getMessage(), null, null, e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e) : new SAXParseException(e.getMessage(), null, null, -1, -1, e);
            spe.initCause(e);
            throw spe;
        }
    }

    private String getPrefixedName(String prefix, String localName) {
        if (prefix == null || prefix.length() == 0) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    private String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!"http://xml.org/sax/properties/lexical-handler".equals(name)) {
            throw new SAXNotRecognizedException(name);
        }
        this.lexicalHandler = (LexicalHandler)value;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (handler instanceof LexicalHandler && this.lexicalHandler == null) {
            this.lexicalHandler = (LexicalHandler)((Object)handler);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        this.parse();
    }

    @Override
    public void parse(String systemId) throws SAXException {
        this.parse();
    }

    class StAX2SAXAttributes
    implements Attributes {
        private int attributeCount;

        StAX2SAXAttributes() {
        }

        void init() {
            this.attributeCount = StAX2SAXSource.this.streamReader.getAttributeCount();
        }

        void reset() {
            this.attributeCount = 0;
        }

        @Override
        public int getLength() {
            return this.attributeCount;
        }

        private boolean checkIndex(int index) {
            return index >= 0 && index < this.attributeCount;
        }

        @Override
        public String getURI(int index) {
            if (!this.checkIndex(index)) {
                return null;
            }
            return StAX2SAXSource.this.nullToEmpty(StAX2SAXSource.this.streamReader.getAttributeNamespace(index));
        }

        @Override
        public String getLocalName(int index) {
            if (!this.checkIndex(index)) {
                return null;
            }
            return StAX2SAXSource.this.streamReader.getAttributeLocalName(index);
        }

        @Override
        public String getQName(int index) {
            if (!this.checkIndex(index)) {
                return null;
            }
            String localName = StAX2SAXSource.this.streamReader.getAttributeLocalName(index);
            String prefix = StAX2SAXSource.this.streamReader.getAttributePrefix(index);
            return StAX2SAXSource.this.getPrefixedName(prefix, localName);
        }

        @Override
        public String getType(int index) {
            if (!this.checkIndex(index)) {
                return null;
            }
            return StAX2SAXSource.this.streamReader.getAttributeType(index);
        }

        @Override
        public String getValue(int index) {
            if (!this.checkIndex(index)) {
                return null;
            }
            return StAX2SAXSource.this.nullToEmpty(StAX2SAXSource.this.streamReader.getAttributeValue(index));
        }

        @Override
        public int getIndex(String searchUri, String searchLocalName) {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!this.getURI(i).equals(searchUri) || !this.getLocalName(i).equals(searchLocalName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String searchQName) {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!this.getQName(i).equals(searchQName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            return this.getType(this.getIndex(uri, localName));
        }

        @Override
        public String getType(String qName) {
            return this.getType(this.getIndex(qName));
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }

        @Override
        public String getValue(String qName) {
            return this.getValue(this.getIndex(qName));
        }
    }
}

