/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.xml.io;

import java.io.IOException;
import org.apache.camel.spi.Resource;
import org.apache.camel.xml.in.ModelParser;
import org.apache.camel.xml.io.XmlPullParserException;

public class XmlModelParser
extends ModelParser {
    private static final String SPRING_NS = "http://camel.apache.org/schema/spring";
    private static final String BLUEPRINT_NS = "http://camel.apache.org/schema/blueprint";

    public XmlModelParser(Resource input, String namespace) throws IOException, XmlPullParserException {
        super(input, namespace);
        this.addSecondaryNamespace(SPRING_NS);
        this.addSecondaryNamespace(BLUEPRINT_NS);
    }

    protected boolean handleUnexpectedElement(String namespace, String name) throws XmlPullParserException {
        if (this.isWithinCamelContext(namespace, name) || this.isAriesBlueprint(namespace)) {
            return true;
        }
        if ("dataFormats".equals(name) && this.isCamelRoot("dataFormats")) {
            return true;
        }
        return super.handleUnexpectedElement(namespace, name);
    }

    protected boolean ignoreUnexpectedElement(String namespace, String name) throws XmlPullParserException {
        if (this.isWithinCamelContext(namespace, name) || this.isAriesBlueprint(namespace)) {
            return true;
        }
        return super.ignoreUnexpectedElement(namespace, name);
    }

    private boolean isAriesBlueprint(String namespace) {
        return namespace != null && namespace.startsWith("http://aries.apache.org/blueprint/");
    }

    private boolean isWithinCamelContext(String namespace, String name) {
        String[] stack;
        if ("camelContext".equals(name) && (SPRING_NS.equals(namespace) || BLUEPRINT_NS.equals(namespace))) {
            return true;
        }
        for (String s : stack = this.parser.getNames()) {
            if (!"camelContext".equals(s) || !SPRING_NS.equals(namespace) && !BLUEPRINT_NS.equals(namespace)) continue;
            return true;
        }
        return false;
    }

    private boolean isCamelRoot(String name) {
        String[] stack = this.parser.getNames();
        for (int i = 0; i < stack.length - 1; ++i) {
            String cur = stack[i];
            String next = stack[i + 1];
            if (!"camel".equals(cur) || !name.equals(next)) continue;
            return true;
        }
        return false;
    }
}

