/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xj;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.Metadata;

public final class XJConstants {
    public static final String NS_XJ = "http://camel.apache.org/component/xj";
    public static final String NS_PREFIX_XJ = "xj";
    public static final String TYPE_HINT_NAME = "name";
    public static final String TYPE_HINT_TYPE = "type";
    @Metadata(description="The XSLT file name", javaType="String")
    public static final String XSLT_FILE_NAME = "CamelXsltFileName";
    static final Map<JsonToken, String> JSONTYPE_TYPE_MAP;
    static final Map<String, JsonToken> TYPE_JSONTYPE_MAP;
    static final String UNSUPPORTED_OPERATION_EXCEPTION_MESSAGE = "unsupported / not yet implemented";
    static final String JSON_WRITER_MIXED_CONTENT_TEXT_KEY = "#text";

    private XJConstants() {
    }

    static {
        EnumMap<JsonToken, String> jsonTypeTypeMap = new EnumMap<JsonToken, String>(JsonToken.class);
        jsonTypeTypeMap.put(JsonToken.START_OBJECT, "object");
        jsonTypeTypeMap.put(JsonToken.END_OBJECT, "object");
        jsonTypeTypeMap.put(JsonToken.START_ARRAY, "array");
        jsonTypeTypeMap.put(JsonToken.END_ARRAY, "array");
        jsonTypeTypeMap.put(JsonToken.VALUE_STRING, "string");
        jsonTypeTypeMap.put(JsonToken.VALUE_NUMBER_INT, "int");
        jsonTypeTypeMap.put(JsonToken.VALUE_NUMBER_FLOAT, "float");
        jsonTypeTypeMap.put(JsonToken.VALUE_TRUE, "boolean");
        jsonTypeTypeMap.put(JsonToken.VALUE_FALSE, "boolean");
        jsonTypeTypeMap.put(JsonToken.VALUE_NULL, "null");
        JSONTYPE_TYPE_MAP = Collections.unmodifiableMap(jsonTypeTypeMap);
        HashMap<String, JsonToken> typeJsonTypeMap = new HashMap<String, JsonToken>();
        typeJsonTypeMap.put("object", JsonToken.START_OBJECT);
        typeJsonTypeMap.put("array", JsonToken.START_ARRAY);
        typeJsonTypeMap.put("string", JsonToken.VALUE_STRING);
        typeJsonTypeMap.put("int", JsonToken.VALUE_NUMBER_INT);
        typeJsonTypeMap.put("float", JsonToken.VALUE_NUMBER_FLOAT);
        typeJsonTypeMap.put("boolean", JsonToken.VALUE_TRUE);
        typeJsonTypeMap.put("null", JsonToken.VALUE_NULL);
        TYPE_JSONTYPE_MAP = Collections.unmodifiableMap(typeJsonTypeMap);
    }
}

