/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xchange.XChange;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.component.xchange.XChangeHelper;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.utils.Assert;

@Component(value="xchange")
public class XChangeComponent
extends DefaultComponent {
    private final Map<String, XChange> xchanges = new HashMap<String, XChange>();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XChangeConfiguration configuration = new XChangeConfiguration();
        configuration.setName(remaining);
        XChangeEndpoint endpoint = new XChangeEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        XChange xchange = this.getOrCreateXChange(remaining);
        endpoint.setXchange(xchange);
        return endpoint;
    }

    public XChange getXChange(String name) {
        return this.xchanges.get(name);
    }

    void putXChange(String name, XChange xchange) {
        this.xchanges.put(name, xchange);
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.xchanges.clear();
    }

    protected Exchange createExchange(Class<? extends Exchange> exchangeClass) {
        return ExchangeFactory.INSTANCE.createExchange(exchangeClass);
    }

    private synchronized XChange getOrCreateXChange(String name) {
        return this.xchanges.computeIfAbsent(name, xc -> {
            Class<? extends Exchange> exchangeClass = XChangeHelper.loadXChangeClass(this.getCamelContext(), name);
            Assert.notNull(exchangeClass, (String)("XChange not supported: " + name));
            return new XChange(this.createExchange(exchangeClass));
        });
    }
}

