/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.whatsapp.WhatsAppConfiguration;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatsAppWebhookProcessor
extends AsyncProcessorSupport
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(WhatsAppWebhookProcessor.class);
    private static final String MODE_QUERY_PARAM = "hub.mode";
    private static final String VERIFY_TOKEN_QUERY_PARAM = "hub.verify_token";
    private static final String CHALLENGE_QUERY_PARAM = "hub.challenge";
    private final WhatsAppConfiguration configuration;
    private AsyncProcessor next;

    public WhatsAppWebhookProcessor(Processor next, WhatsAppConfiguration configuration) {
        this.next = AsyncProcessorConverterHelper.convert((Processor)next);
        this.configuration = configuration;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        String content;
        if ("GET".equalsIgnoreCase(exchange.getIn().getHeader("CamelHttpMethod").toString())) {
            Map<String, String> queryParams = this.parseQueryParam(exchange);
            String mode = queryParams.get(MODE_QUERY_PARAM);
            String token = queryParams.get(VERIFY_TOKEN_QUERY_PARAM);
            String challenge = queryParams.get(CHALLENGE_QUERY_PARAM);
            if (mode != null && token != null) {
                if ("subscribe".equals(mode) && token.equals(this.configuration.getWebhookVerifyToken())) {
                    LOG.info("WhatsApp Webhook verified and subscribed");
                    content = challenge;
                } else {
                    content = null;
                    exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)403);
                }
            } else {
                LOG.error("{} or {} missing from request query param", (Object)MODE_QUERY_PARAM, (Object)VERIFY_TOKEN_QUERY_PARAM);
                content = null;
                exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)400);
            }
        } else {
            InputStream body = (InputStream)exchange.getIn().getBody(InputStream.class);
            try {
                content = new String(body.readAllBytes());
            }
            catch (IOException e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        exchange.getMessage().setBody((Object)content);
        return this.next.process(exchange, doneSync -> {
            exchange.getMessage().setBody((Object)content);
            callback.done(doneSync);
        });
    }

    private Map<String, String> parseQueryParam(Exchange exchange) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (exchange.getIn().getHeader("CamelHttpQuery") != null) {
            String[] pairs;
            for (String pair : pairs = exchange.getIn().getHeader("CamelHttpQuery").toString().split("&")) {
                String[] keyValuePair = pair.split("=");
                queryParams.put(keyValuePair[0], keyValuePair[1]);
            }
        }
        return queryParams;
    }
}

