/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public final class RestAdapterUtils {
    public static final byte[] EXTRA_BYTES = "--".getBytes();
    public static final byte[] NEW_LINE_BYTES = "\r\n".getBytes();
    public static final byte[] CONTENT_DISPOSITION_BYTES = "Content-Disposition: form-data; name=".getBytes();
    public static final byte[] QUOTE_BYTES = "\"".getBytes();
    public static final byte[] FILE_NAME_HEADER_BYTES = "\"; filename=\"".getBytes();
    public static final byte[] CONTENT_TYPE_HEADER_BYTES = "\"\r\nContent-Type: ".getBytes();

    private RestAdapterUtils() {
    }

    public static ByteBuffer generateByteBuffer(byte[] ... bytes) {
        int size = Arrays.stream(bytes).map(b -> ((byte[])b).length).reduce(0, Integer::sum);
        return RestAdapterUtils.getByteBuffer(size, bytes);
    }

    private static ByteBuffer getByteBuffer(int size, byte[][] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (byte[] byteArray : bytes) {
            buffer.put(byteArray);
        }
        return buffer;
    }

    public static ByteBuffer generateByteBuffer(List<byte[]> bytes) {
        int size = bytes.stream().map(b -> ((byte[])b).length).reduce(0, Integer::sum);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (byte[] byteArray : bytes) {
            buffer.put(byteArray);
        }
        return buffer;
    }
}

