/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.whatsapp.WhatsAppEndpoint;
import org.apache.camel.component.whatsapp.WhatsAppService;
import org.apache.camel.component.whatsapp.model.BaseMessage;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatsAppProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(WhatsAppProducer.class);
    private WhatsAppEndpoint endpoint;

    public WhatsAppProducer(WhatsAppEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (exchange.getIn().getBody() == null) {
            LOG.debug("Received exchange with empty body, skipping");
            callback.done(true);
            return true;
        }
        BaseMessage message = (BaseMessage)exchange.getIn().getBody(BaseMessage.class);
        ObjectHelper.notNull((Object)message, (String)"message");
        WhatsAppService service = this.endpoint.getWhatsappService();
        LOG.debug("Message being sent is: {}", (Object)message);
        LOG.debug("Headers of message being sent are: {}", (Object)exchange.getIn().getHeaders());
        service.sendMessage(exchange, callback, message);
        return false;
    }
}

