/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weaviate;

import io.weaviate.client.WeaviateClient;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@Configurer
@UriParams
public class WeaviateVectorDbConfiguration
implements Cloneable {
    @Metadata(label="producer", description="Scheme used to connect to weaviate")
    @UriParam
    private String scheme;
    @Metadata(label="producer", description="Weaviate server host to connect to")
    @UriParam
    private String host;
    @Metadata(label="producer", description="Proxy host to connect to weaviate through")
    @UriParam
    private String proxyHost;
    @Metadata(label="producer", description="Proxy port to connect to weaviate through")
    @UriParam
    private Integer proxyPort;
    @Metadata(label="producer", description="Proxy scheme to connect to weaviate through")
    @UriParam
    private String proxyScheme;
    @Metadata(label="producer", description="API Key to authenticate to weaviate with", secret=true)
    @UriParam
    private String apiKey;
    @Metadata(autowired=true)
    private WeaviateClient client;

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public void setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
    }

    public WeaviateClient getClient() {
        return this.client;
    }

    public void setClient(WeaviateClient client) {
        this.client = client;
    }

    public WeaviateVectorDbConfiguration copy() {
        try {
            return (WeaviateVectorDbConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

