/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weaviate.transform;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Message;
import org.apache.camel.component.weaviate.WeaviateVectorDbAction;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;

@DataTypeTransformer(name="weaviate:embeddings", description="Prepares the message to become an object writable by Weaviate component")
public class WeaviateEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Embedding embedding = (Embedding)message.getHeader("CamelLangChain4jEmbeddingsVector", Embedding.class);
        String textFieldName = (String)message.getHeader("CamelWeaviateTextFieldName", () -> "text", String.class);
        String vectorFieldName = (String)message.getHeader("CamelweaviateVectorFieldName", () -> "vector", String.class);
        String collectionName = (String)message.getHeader("CamelWeaviateCollectionName", () -> "embeddings", String.class);
        String keyName = (String)message.getHeader("CamelWeaviateKeyName", () -> "id", String.class);
        Object keyValue = message.getHeader("CamelWeaviateKeyValue", () -> null);
        TextSegment text = (TextSegment)message.getBody(TextSegment.class);
        WeaviateVectorDbAction action = (WeaviateVectorDbAction)((Object)message.getHeader("CamelWeaviateAction", WeaviateVectorDbAction.class));
        switch (action) {
            case CREATE: {
                WeaviateEmbeddingsDataTypeTransformer.createEmbeddingOperation(message, embedding, vectorFieldName, textFieldName, text, collectionName, keyValue, keyName);
                break;
            }
            case UPDATE_BY_ID: {
                WeaviateEmbeddingsDataTypeTransformer.updateEmbeddingOperation(message, embedding, vectorFieldName, textFieldName, text, collectionName, keyValue, keyName);
                break;
            }
            case QUERY: {
                WeaviateEmbeddingsDataTypeTransformer.queryEmbeddingOperation(message, embedding, vectorFieldName, textFieldName, text, collectionName, keyValue, keyName);
                break;
            }
            default: {
                throw new IllegalStateException("The only operations supported are create and updatebyid");
            }
        }
    }

    private static void createEmbeddingOperation(Message message, Embedding embedding, String vectorFieldName, String textFieldName, TextSegment text, String collectionName, Object keyValue, String keyName) {
        message.setBody((Object)embedding.vectorAsList(), List.class);
        if (ObjectHelper.isNotEmpty((Object)keyValue) && ObjectHelper.isNotEmpty((String)keyName)) {
            HashMap<String, Object> maps = new HashMap<String, Object>();
            maps.put(keyName, keyValue);
            message.setHeader("CamelWeaviateProperties", maps);
        }
    }

    private static void updateEmbeddingOperation(Message message, Embedding embedding, String vectorFieldName, String textFieldName, TextSegment text, String collectionName, Object keyValue, String keyName) {
        message.setBody((Object)embedding.vectorAsList(), List.class);
        if (ObjectHelper.isNotEmpty((Object)keyValue) && ObjectHelper.isNotEmpty((String)keyName)) {
            HashMap<String, Object> maps = new HashMap<String, Object>();
            maps.put(keyName, keyValue);
            message.setHeader("CamelWeaviateProperties", maps);
        }
    }

    private static void queryEmbeddingOperation(Message message, Embedding embedding, String vectorFieldName, String textFieldName, TextSegment text, String collectionName, Object keyValue, String keyName) {
        message.setBody((Object)embedding.vectorAsList(), List.class);
        if (ObjectHelper.isNotEmpty((Object)keyValue) && ObjectHelper.isNotEmpty((String)keyName)) {
            HashMap<String, Object> maps = new HashMap<String, Object>();
            maps.put(keyName, keyValue);
            message.setHeader("CamelWeaviateProperties", maps);
        }
    }
}

