/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weaviate;

import io.weaviate.client.WeaviateClient;
import io.weaviate.client.base.Result;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.builder.GetBuilder;
import io.weaviate.client.v1.graphql.query.fields.Field;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.schema.model.WeaviateClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.weaviate.WeaviateVectorDbAction;
import org.apache.camel.component.weaviate.WeaviateVectorDbEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;

public class WeaviateVectorDbProducer
extends DefaultProducer {
    private WeaviateClient client;
    private ExecutorService executor;

    public WeaviateVectorDbProducer(WeaviateVectorDbEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public WeaviateVectorDbEndpoint getEndpoint() {
        return (WeaviateVectorDbEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client = this.getEndpoint().getClient();
    }

    public void process(Exchange exchange) {
        Message in = exchange.getMessage();
        WeaviateVectorDbAction action = (WeaviateVectorDbAction)((Object)in.getHeader("CamelWeaviateAction", WeaviateVectorDbAction.class));
        try {
            if (action == null) {
                throw new NoSuchHeaderException("The action is a required header", exchange, "CamelWeaviateAction");
            }
            switch (action) {
                case CREATE_COLLECTION: {
                    this.createCollection(exchange);
                    break;
                }
                case CREATE: {
                    this.create(exchange);
                    break;
                }
                case UPDATE_BY_ID: {
                    this.updateById(exchange);
                    break;
                }
                case DELETE_BY_ID: {
                    this.deleteById(exchange);
                    break;
                }
                case DELETE_COLLECTION: {
                    this.deleteCollection(exchange);
                    break;
                }
                case QUERY: {
                    this.query(exchange);
                    break;
                }
                case QUERY_BY_ID: {
                    this.queryById(exchange);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported action: " + action.name());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    private void createCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        WeaviateClass collection = WeaviateClass.builder().className(collectionName).build();
        Result res = this.client.misc().readyChecker().run();
        Result result = this.client.schema().classCreator().withClass(collection).run();
        this.populateResponse(result, exchange);
    }

    private void create(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        HashMap props = (HashMap)in.getHeader("CamelWeaviateProperties", HashMap.class);
        Float[] vectors = elements.toArray(new Float[0]);
        Result result = this.client.data().creator().withClassName(collectionName).withVector(vectors).withProperties((Map)props).run();
        this.populateResponse(result, exchange);
    }

    private void updateById(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexId = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelWeaviateIndexId", String.class);
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        Float[] vectors = elements.toArray(new Float[0]);
        Result result = this.client.data().updater().withMerge().withID(indexId).withClassName(collectionName).withVector(vectors).run();
        this.populateResponse(result, exchange);
    }

    private void deleteById(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexId = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelWeaviateIndexId", String.class);
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        Result result = this.client.data().deleter().withClassName(collectionName).withID(indexId).run();
        this.populateResponse(result, exchange);
    }

    private void deleteCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        Result result = this.client.schema().classDeleter().withClassName(collectionName).run();
        this.populateResponse(result, exchange);
    }

    private void query(Exchange exchange) throws Exception {
        Fields fields;
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        int topK = 10;
        if (in.getHeader("CamelWeaviateQueryTopK", Integer.class) != null) {
            topK = (Integer)in.getHeader("CamelWeaviateQueryTopK", Integer.class);
        }
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        Float[] vectors = elements.toArray(new Float[0]);
        NearVectorArgument nearVectorArg = NearVectorArgument.builder().vector(vectors).build();
        if (in.getHeader("CamelWeaviateFields", HashMap.class) != null) {
            HashMap fieldToSearch = (HashMap)in.getHeader("CamelWeaviateFields", HashMap.class);
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (String key : fieldToSearch.keySet()) {
                fieldList.add(Field.builder().name(key).build());
            }
            Field[] fieldArray = (Field[])fieldList.toArray();
            fields = Fields.builder().fields(fieldArray).build();
        } else {
            fields = Fields.builder().fields(new Field[0]).build();
        }
        String query = GetBuilder.builder().className(collectionName).fields(fields).withNearVectorFilter(nearVectorArg).limit(Integer.valueOf(topK)).build().buildQuery();
        Result result = this.client.graphQL().raw().withQuery(query).run();
        this.populateResponse(result, exchange);
    }

    private void queryById(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexId = (String)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"CamelWeaviateIndexId", String.class);
        String collectionName = in.getHeader("CamelWeaviateCollectionName", String.class) != null ? (String)in.getHeader("CamelWeaviateCollectionName", String.class) : this.getEndpoint().getCollection();
        Result result = this.client.data().objectsGetter().withClassName(collectionName).withID(indexId).run();
        this.populateResponse(result, exchange);
    }

    private CamelContext getCamelContext() {
        return this.getEndpoint().getCamelContext();
    }

    private void populateResponse(Result<?> r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody(r);
    }
}

