/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.wasm;

import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Module;
import com.dylibso.chicory.wasm.types.Value;
import java.util.Objects;

public class WasmFunction
implements AutoCloseable {
    private final Object lock = new Object();
    private final Module module;
    private final String functionName;
    private final Instance instance;
    private final ExportFunction function;
    private final ExportFunction alloc;
    private final ExportFunction dealloc;

    public WasmFunction(Module module, String functionName) {
        this.module = Objects.requireNonNull(module);
        this.functionName = Objects.requireNonNull(functionName);
        this.instance = this.module.instantiate();
        this.function = this.instance.export(this.functionName);
        this.alloc = this.instance.export("alloc");
        this.dealloc = this.instance.export("dealloc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] run(byte[] in) throws Exception {
        Objects.requireNonNull(in);
        int inPtr = -1;
        int inSize = in.length;
        int outPtr = -1;
        int outSize = 0;
        Object object = this.lock;
        synchronized (object) {
            byte[] byArray;
            block10: {
                try {
                    inPtr = this.alloc.apply(new Value[]{Value.i32((int)inSize)})[0].asInt();
                    this.instance.memory().write(inPtr, in);
                    Value[] results = this.function.apply(new Value[]{Value.i32((int)inPtr), Value.i32((int)inSize)});
                    long ptrAndSize = results[0].asLong();
                    outPtr = (int)(ptrAndSize >> 32);
                    outSize = (int)ptrAndSize;
                    if (WasmFunction.isError(outSize)) {
                        int errSize = WasmFunction.errSize(outSize);
                        String errData = this.instance.memory().readString(outPtr, errSize);
                        throw new RuntimeException(errData);
                    }
                    byArray = this.instance.memory().readBytes(outPtr, outSize);
                    if (inPtr == -1) break block10;
                }
                catch (Throwable throwable) {
                    if (inPtr != -1) {
                        this.dealloc.apply(new Value[]{Value.i32((int)inPtr), Value.i32((int)inSize)});
                    }
                    if (outPtr != -1) {
                        this.dealloc.apply(new Value[]{Value.i32((int)outPtr), Value.i32((int)outSize)});
                    }
                    throw throwable;
                }
                this.dealloc.apply(new Value[]{Value.i32((int)inPtr), Value.i32((int)inSize)});
            }
            if (outPtr != -1) {
                this.dealloc.apply(new Value[]{Value.i32((int)outPtr), Value.i32((int)outSize)});
            }
            return byArray;
        }
    }

    @Override
    public void close() throws Exception {
    }

    private static boolean isError(int number) {
        return (number & Integer.MIN_VALUE) != 0;
    }

    private static int errSize(int number) {
        return number & Integer.MAX_VALUE;
    }
}

