/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.component.vertx.websocket.VertxWebsocketPeer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="vertx-websocket", displayName="Vert.x WebSocket", description="Vert.x WebSocket consumer details")
public class VertxWebsocketDevConsole
extends AbstractDevConsole {
    public static final String INCLUDE_HEADERS = "includeHeaders";

    public VertxWebsocketDevConsole() {
        super("camel", "vertx-websocket", "Vert.x WebSocket", "Vert.x WebSocket consumer details");
    }

    protected String doCallText(Map<String, Object> options) {
        boolean includeHeaders = "true".equals(options.getOrDefault(INCLUDE_HEADERS, "true"));
        StringBuilder sb = new StringBuilder();
        Map<VertxWebsocketHostKey, List<VertxWebsocketConsumer>> consumersByHost = this.getConsumersByHost();
        for (Map.Entry<VertxWebsocketHostKey, List<VertxWebsocketConsumer>> hostEntry : consumersByHost.entrySet()) {
            VertxWebsocketHostKey hostKey = hostEntry.getKey();
            sb.append(String.format("\n    Host: %s", hostKey.toString()));
            for (VertxWebsocketConsumer consumer : hostEntry.getValue()) {
                String path = consumer.getEndpoint().getConfiguration().getWebsocketURI().getPath();
                sb.append(String.format("\n        Path: %s", path));
                List<VertxWebsocketPeer> pathPeers = consumer.getEndpoint().getVertxHostRegistry().values().stream().flatMap(host -> host.getConnectedPeers().stream()).filter(peer -> peer.getRawPath().equals(path)).toList();
                sb.append(String.format("\n            Connected Peers (%d): ", pathPeers.size()));
                for (VertxWebsocketPeer peer2 : pathPeers) {
                    sb.append(String.format("\n                ID: %s", peer2.getConnectionKey()));
                    sb.append(String.format("\n                Path: %s", peer2.getPath()));
                    sb.append(String.format("\n                Raw Path: %s", peer2.getRawPath()));
                    ServerWebSocket webSocket = peer2.getWebSocket();
                    SocketAddress socketAddress = webSocket.localAddress();
                    String hostAddress = socketAddress == null ? "Unknown" : socketAddress.hostAddress();
                    sb.append(String.format("\n                Host Address: %s", hostAddress));
                    if (webSocket.subProtocol() != null) {
                        sb.append(String.format("\n                Sub Protocol: %s", webSocket.subProtocol()));
                    }
                    if (!includeHeaders) continue;
                    sb.append(String.format("\n                Headers: %s", webSocket.headers().entries().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", "))));
                }
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        boolean includeHeaders = "true".equals(options.getOrDefault(INCLUDE_HEADERS, "true"));
        JsonObject root = new JsonObject();
        JsonArray hosts = new JsonArray();
        Map<VertxWebsocketHostKey, List<VertxWebsocketConsumer>> consumersByHost = this.getConsumersByHost();
        for (Map.Entry<VertxWebsocketHostKey, List<VertxWebsocketConsumer>> hostEntry : consumersByHost.entrySet()) {
            VertxWebsocketHostKey hostKey = hostEntry.getKey();
            JsonObject host = new JsonObject();
            host.put((Object)"host", (Object)hostKey.toString());
            JsonArray paths = new JsonArray();
            for (VertxWebsocketConsumer consumer : hostEntry.getValue()) {
                String path = consumer.getEndpoint().getConfiguration().getWebsocketURI().getPath();
                JsonObject pathJson = new JsonObject();
                pathJson.put((Object)"path", (Object)path);
                List<VertxWebsocketPeer> pathPeers = consumer.getEndpoint().getVertxHostRegistry().values().stream().flatMap(h -> h.getConnectedPeers().stream()).filter(peer -> peer.getRawPath().equals(path)).toList();
                JsonArray peers = new JsonArray();
                for (VertxWebsocketPeer peer2 : pathPeers) {
                    JsonObject peerJson = new JsonObject();
                    peerJson.put((Object)"id", (Object)peer2.getConnectionKey());
                    peerJson.put((Object)"path", (Object)peer2.getPath());
                    peerJson.put((Object)"rawPath", (Object)peer2.getRawPath());
                    ServerWebSocket webSocket = peer2.getWebSocket();
                    SocketAddress socketAddress = webSocket.localAddress();
                    String hostAddress = socketAddress == null ? "Unknown" : socketAddress.hostAddress();
                    peerJson.put((Object)"hostAddress", (Object)hostAddress);
                    peerJson.put((Object)"subProtocol", (Object)webSocket.subProtocol());
                    if (includeHeaders) {
                        JsonObject headers = new JsonObject();
                        webSocket.headers().entries().forEach(e -> headers.put((Object)((String)e.getKey()), e.getValue()));
                        peerJson.put((Object)"headers", (Object)headers);
                    }
                    peers.add((Object)peerJson);
                }
                pathJson.put((Object)"peers", (Object)peers);
                paths.add((Object)pathJson);
            }
            host.put((Object)"paths", (Object)paths);
            hosts.add((Object)host);
        }
        root.put((Object)"hosts", (Object)hosts);
        return root;
    }

    Map<VertxWebsocketHostKey, List<VertxWebsocketConsumer>> getConsumersByHost() {
        LinkedHashMap<VertxWebsocketHostKey, List<VertxWebsocketConsumer>> consumersByHost = new LinkedHashMap<VertxWebsocketHostKey, List<VertxWebsocketConsumer>>();
        for (Route route : this.getCamelContext().getRoutes()) {
            Consumer consumer = route.getConsumer();
            if (!(consumer instanceof VertxWebsocketConsumer)) continue;
            VertxWebsocketConsumer consumer2 = (VertxWebsocketConsumer)consumer;
            VertxWebsocketHostKey hostKey = new VertxWebsocketHostKey(consumer2.getEndpoint().getConfiguration().getWebsocketURI().getHost(), consumer2.getEndpoint().getConfiguration().getWebsocketURI().getPort());
            consumersByHost.computeIfAbsent(hostKey, k -> new ArrayList()).add(consumer2);
        }
        return consumersByHost;
    }
}

