/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHost;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.component.vertx.websocket.VertxWebsocketPeer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="vertx-websocket", displayName="Vert.x WebSocket", description="Vert.x WebSocket consumer details")
public class VertxWebsocketDevConsole
extends AbstractDevConsole {
    public static final String INCLUDE_HEADERS = "includeHeaders";

    public VertxWebsocketDevConsole() {
        super("camel", "vertx-websocket", "Vert.x WebSocket", "Vert.x WebSocket consumer details");
    }

    protected String doCallText(Map<String, Object> options) {
        boolean includeHeaders = "true".equals(options.getOrDefault(INCLUDE_HEADERS, "true"));
        StringBuilder sb = new StringBuilder();
        Set<Map<VertxWebsocketHostKey, VertxWebsocketHost>> vertxHostRegistries = this.getHostRegistries();
        for (Map<VertxWebsocketHostKey, VertxWebsocketHost> vertxHostRegistry : vertxHostRegistries) {
            for (Map.Entry<VertxWebsocketHostKey, VertxWebsocketHost> entry : vertxHostRegistry.entrySet()) {
                VertxWebsocketHostKey hostKey = entry.getKey();
                sb.append(String.format("\n    Host: %s", hostKey.toString()));
                List<VertxWebsocketPeer> connectedPeers = entry.getValue().getConnectedPeers();
                sb.append(String.format("\n        Connected Peers (%d): ", connectedPeers.size()));
                for (VertxWebsocketPeer peer : connectedPeers) {
                    sb.append(String.format("\n            Path: %s", peer.getPath()));
                    ServerWebSocket webSocket = peer.getWebSocket();
                    SocketAddress socketAddress = webSocket.localAddress();
                    String hostAddress = socketAddress == null ? "Unknown" : socketAddress.hostAddress();
                    sb.append(String.format("\n            Host Address: %s", hostAddress));
                    if (webSocket.subProtocol() != null) {
                        sb.append(String.format("\n            Sub Protocol: %s", webSocket.subProtocol()));
                    }
                    if (!includeHeaders) continue;
                    sb.append(String.format("\n            Headers: %s", webSocket.headers().entries().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", "))));
                }
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        boolean includeHeaders = "true".equals(options.getOrDefault(INCLUDE_HEADERS, "true"));
        Set<Map<VertxWebsocketHostKey, VertxWebsocketHost>> vertxHostRegistries = this.getHostRegistries();
        JsonObject root = new JsonObject();
        JsonArray hosts = new JsonArray();
        for (Map<VertxWebsocketHostKey, VertxWebsocketHost> vertxHostRegistry : vertxHostRegistries) {
            for (Map.Entry<VertxWebsocketHostKey, VertxWebsocketHost> entry : vertxHostRegistry.entrySet()) {
                VertxWebsocketHostKey hostKey = entry.getKey();
                JsonObject host = new JsonObject();
                host.put((Object)"host", (Object)hostKey.toString());
                JsonArray peers = new JsonArray();
                for (VertxWebsocketPeer peer : entry.getValue().getConnectedPeers()) {
                    JsonObject peerJson = new JsonObject();
                    peerJson.put((Object)"path", (Object)peer.getPath());
                    ServerWebSocket webSocket = peer.getWebSocket();
                    SocketAddress socketAddress = webSocket.localAddress();
                    String hostAddress = socketAddress == null ? "Unknown" : socketAddress.hostAddress();
                    peerJson.put((Object)"hostAddress", (Object)hostAddress);
                    peerJson.put((Object)"subProtocol", (Object)webSocket.subProtocol());
                    if (includeHeaders) {
                        JsonObject headers = new JsonObject();
                        webSocket.headers().entries().forEach(e -> headers.put((Object)((String)e.getKey()), e.getValue()));
                        peerJson.put((Object)"headers", (Object)headers);
                    }
                    peers.add((Object)peerJson);
                }
                host.put((Object)"peers", (Object)peers);
                hosts.add((Object)host);
            }
        }
        root.put((Object)"hosts", (Object)hosts);
        return root;
    }

    Set<Map<VertxWebsocketHostKey, VertxWebsocketHost>> getHostRegistries() {
        LinkedHashSet<Map<VertxWebsocketHostKey, VertxWebsocketHost>> hostRegistries = new LinkedHashSet<Map<VertxWebsocketHostKey, VertxWebsocketHost>>();
        for (Route route : this.getCamelContext().getRoutes()) {
            Consumer consumer = route.getConsumer();
            if (!(consumer instanceof VertxWebsocketConsumer)) continue;
            VertxWebsocketConsumer consumer2 = (VertxWebsocketConsumer)consumer;
            hostRegistries.add(consumer2.getEndpoint().getVertxHostRegistry());
        }
        return hostRegistries;
    }
}

