/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import org.apache.camel.spi.Metadata;

public final class VertxWebsocketConstants {
    public static final String DEFAULT_VERTX_SERVER_HOST = "0.0.0.0";
    public static final int DEFAULT_VERTX_SERVER_PORT = 0;
    public static final int DEFAULT_VERTX_CLIENT_WS_PORT = 80;
    public static final int DEFAULT_VERTX_CLIENT_WSS_PORT = 443;
    public static final String ORIGIN_HTTP_HEADER_NAME = "Origin";
    @Metadata(description="Sends the message to the client with the given connection key. You can\nuse a comma separated list of keys to send a message to multiple clients. Note that this option only applies when producing messages to endpoints hosted by the vertx-websocket consumer and not to an externally hosted WebSocket.", javaType="String")
    public static final String CONNECTION_KEY = "CamelVertxWebsocket.connectionKey";
    @Metadata(label="producer", description="Sends the message to all clients which are currently connected. You can\nuse the `sendToAll` option on the endpoint instead of using this header. Note that this option only applies when producing messages to endpoints hosted by the vertx-websocket consumer and not to an externally hosted WebSocket.", javaType="boolean")
    public static final String SEND_TO_ALL = "CamelVertxWebsocket.sendToAll";
    @Metadata(label="consumer", description="The remote address.", javaType="io.vertx.core.net.SocketAddress")
    public static final String REMOTE_ADDRESS = "CamelVertxWebsocket.remoteAddress";
    @Metadata(label="consumer", description="The WebSocket event that triggered the message exchange.", javaType="org.apache.camel.component.vertx.websocket.VertxWebsocketEvent")
    public static final String EVENT = "CamelVertxWebsocket.event";

    private VertxWebsocketConstants() {
    }
}

