/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import org.apache.camel.spi.Metadata;

public final class VertxHttpConstants {
    public static final String CONTENT_TYPE_JAVA_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    public static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    @Metadata(description="The http method", javaType="io.vertx.core.http.HttpMethod")
    public static final String HTTP_METHOD = "CamelHttpMethod";
    @Metadata(description="The HTTP response code from the external server.", javaType="Integer")
    public static final String HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
    @Metadata(description="The HTTP response text from the external server.", javaType="String")
    public static final String HTTP_RESPONSE_TEXT = "CamelHttpResponseText";
    @Metadata(description="The HTTP content type. Is set on both the IN and OUT message to provide\na content type, such as `text/html`.", javaType="String")
    public static final String CONTENT_TYPE = "Content-Type";
    @Metadata(description="URI parameters. Will override existing URI parameters set directly on\nthe endpoint.", javaType="String")
    public static final String HTTP_QUERY = "CamelHttpQuery";
    @Metadata(description="URI to call. Will override the existing URI set directly on the endpoint.\nThis URI is the URI of the http server to call. Its not the same as the\nCamel endpoint URI, where you can configure endpoint options such as\nsecurity etc. This header does not support that, its only the URI of the\nhttp server.", javaType="String")
    public static final String HTTP_URI = "CamelHttpUri";
    @Metadata(description="Request URI's path, the header will be used to build the request URI\nwith the HTTP_URI.", javaType="String")
    public static final String HTTP_PATH = "CamelHttpPath";
    @Metadata(description="The HTTP content encoding. Is set to provide a content encoding, such as `gzip`.", javaType="String")
    public static final String CONTENT_ENCODING = "Content-Encoding";

    private VertxHttpConstants() {
    }
}

