/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceBasedEndpoint;
import org.apache.camel.component.velocity.VelocityComponent;
import org.apache.camel.util.ExchangeHelper;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.SimpleLog4JLogSystem;
import org.springframework.core.io.Resource;

public class VelocityEndpoint
extends ResourceBasedEndpoint {
    private final VelocityComponent component;
    private VelocityEngine velocityEngine;
    private boolean loaderCache = true;
    private String encoding;

    public VelocityEndpoint(String uri, VelocityComponent component, String resourceUri, Map parameters) {
        super(uri, (Component)component, resourceUri, null);
        this.component = component;
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    private VelocityEngine getVelocityEngine() throws Exception {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.component.getVelocityEngine();
            this.velocityEngine.setProperty("file.resource.loader.cache", (Object)(this.isLoaderCache() ? Boolean.TRUE : Boolean.FALSE));
            this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)SimpleLog4JLogSystem.class.getName());
            this.velocityEngine.setProperty("runtime.log.logsystem.log4j.category", (Object)VelocityEndpoint.class.getName());
            this.velocityEngine.init();
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public boolean isLoaderCache() {
        return this.loaderCache;
    }

    public void setLoaderCache(boolean loaderCache) {
        this.loaderCache = loaderCache;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Resource resource = this.getResource();
        InputStreamReader reader = this.encoding != null ? new InputStreamReader(this.getResourceAsInputStream(), this.encoding) : new InputStreamReader(this.getResourceAsInputStream());
        StringWriter buffer = new StringWriter();
        String logTag = ((Object)((Object)this)).getClass().getName();
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        VelocityContext velocityContext = new VelocityContext(variableMap);
        VelocityEngine engine = this.getVelocityEngine();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Velocity is evaluating using velocity context: " + variableMap));
        }
        engine.evaluate((Context)velocityContext, (Writer)buffer, logTag, (Reader)reader);
        Message out = exchange.getOut(true);
        out.setBody((Object)buffer.toString());
        out.setHeader("org.apache.camel.velocity.resource", (Object)resource);
        Map headers = (Map)velocityContext.get("headers");
        for (String key : headers.keySet()) {
            out.setHeader(key, headers.get(key));
        }
    }
}

