/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class HostUtils {
    private HostUtils() {
    }

    public static Map<String, Set<InetAddress>> getNetworkInterfaceAddresses() {
        TreeMap<String, Set<InetAddress>> interfaceAddressMap = new TreeMap<String, Set<InetAddress>>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp() || iface.isLoopback() || iface.isPointToPoint()) continue;
                String name = iface.getName();
                Enumeration<InetAddress> ifaceAdresses = iface.getInetAddresses();
                while (ifaceAdresses.hasMoreElements()) {
                    InetAddress ia = ifaceAdresses.nextElement();
                    if (ia.isLoopbackAddress() || ia.getHostAddress().contains(":")) continue;
                    LinkedHashSet<InetAddress> addresses = (LinkedHashSet<InetAddress>)interfaceAddressMap.get(name);
                    if (addresses == null) {
                        addresses = new LinkedHashSet<InetAddress>();
                    }
                    addresses.add(ia);
                    interfaceAddressMap.put(name, addresses);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return interfaceAddressMap;
    }

    public static Set<InetAddress> getAddresses() {
        LinkedHashSet<InetAddress> allAddresses = new LinkedHashSet<InetAddress>();
        Map<String, Set<InetAddress>> interfaceAddressMap = HostUtils.getNetworkInterfaceAddresses();
        for (Map.Entry<String, Set<InetAddress>> entry : interfaceAddressMap.entrySet()) {
            Set<InetAddress> addresses = entry.getValue();
            if (addresses.isEmpty()) continue;
            allAddresses.addAll(addresses);
        }
        return allAddresses;
    }

    private static InetAddress chooseAddress() throws UnknownHostException {
        Set<InetAddress> addresses = HostUtils.getAddresses();
        if (addresses.contains(InetAddress.getLocalHost())) {
            return InetAddress.getLocalHost();
        }
        if (addresses != null && !addresses.isEmpty()) {
            return addresses.toArray(new InetAddress[0])[0];
        }
        return InetAddress.getLocalHost();
    }

    public static String getLocalHostName() throws UnknownHostException {
        return HostUtils.chooseAddress().getHostName();
    }

    public static String getLocalIp() throws UnknownHostException {
        return HostUtils.chooseAddress().getHostAddress();
    }
}

