/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.BufferCaster;

public final class Scanner
implements Iterator<String>,
Closeable {
    private static final Map<String, Pattern> CACHE = new LinkedHashMap<String, Pattern>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            return this.size() >= 7;
        }
    };
    private static final String WHITESPACE_PATTERN = "\\s+";
    private static final String FIND_ANY_PATTERN = "(?s).*";
    private static final int BUFFER_SIZE = 1024;
    private Readable source;
    private Pattern delimPattern;
    private Matcher matcher;
    private CharBuffer buf;
    private int position;
    private boolean inputExhausted;
    private boolean needInput;
    private boolean skipped;
    private int savedPosition = -1;
    private boolean closed;
    private IOException lastIOException;

    public Scanner(InputStream source, String charsetName, String pattern) {
        this((Readable)new InputStreamReader(Objects.requireNonNull(source, "source"), Scanner.toDecoder(charsetName)), Scanner.cachePattern(pattern));
    }

    public Scanner(File source, String charsetName, String pattern) throws FileNotFoundException {
        this(new FileInputStream(Objects.requireNonNull(source, "source")).getChannel(), charsetName, pattern);
    }

    public Scanner(String source, String pattern) {
        this((Readable)new StringReader(Objects.requireNonNull(source, "source")), Scanner.cachePattern(pattern));
    }

    public Scanner(ReadableByteChannel source, String charsetName, String pattern) {
        this((Readable)Channels.newReader(Objects.requireNonNull(source, "source"), Scanner.toDecoder(charsetName), -1), Scanner.cachePattern(pattern));
    }

    public Scanner(Readable source, String pattern) {
        this(Objects.requireNonNull(source, "source"), Scanner.cachePattern(pattern));
    }

    private Scanner(Readable source, Pattern pattern) {
        this.source = source;
        this.delimPattern = pattern != null ? pattern : Scanner.cachePattern(WHITESPACE_PATTERN);
        this.buf = CharBuffer.allocate(1024);
        BufferCaster.cast(this.buf).limit(0);
        this.matcher = this.delimPattern.matcher(this.buf);
        this.matcher.useTransparentBounds(true);
        this.matcher.useAnchoringBounds(false);
    }

    private static CharsetDecoder toDecoder(String charsetName) {
        try {
            Charset cs = charsetName != null ? Charset.forName(charsetName) : Charset.defaultCharset();
            return cs.newDecoder();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean hasNext() {
        this.checkClosed();
        this.saveState();
        while (!this.inputExhausted) {
            if (this.hasTokenInBuffer()) {
                this.revertState();
                return true;
            }
            this.readMore();
        }
        boolean result = this.hasTokenInBuffer();
        this.revertState();
        return result;
    }

    @Override
    public String next() {
        this.checkClosed();
        while (true) {
            String token;
            if ((token = this.getCompleteTokenInBuffer()) != null) {
                this.skipped = false;
                return token;
            }
            if (this.needInput) {
                this.readMore();
                continue;
            }
            this.throwFor();
        }
    }

    private void saveState() {
        this.savedPosition = this.position;
    }

    private void revertState() {
        this.position = this.savedPosition;
        this.savedPosition = -1;
        this.skipped = false;
    }

    private void readMore() {
        int n;
        if (this.buf.limit() == this.buf.capacity()) {
            this.expandBuffer();
        }
        int p = this.buf.position();
        BufferCaster.cast(this.buf).position(this.buf.limit());
        BufferCaster.cast(this.buf).limit(this.buf.capacity());
        try {
            n = this.source.read(this.buf);
        }
        catch (IOException ioe) {
            this.lastIOException = ioe;
            n = -1;
        }
        if (n == -1) {
            this.inputExhausted = true;
            this.needInput = false;
        } else if (n > 0) {
            this.needInput = false;
        }
        BufferCaster.cast(this.buf).limit(this.buf.position());
        BufferCaster.cast(this.buf).position(p);
    }

    private void expandBuffer() {
        int offset = this.savedPosition == -1 ? this.position : this.savedPosition;
        BufferCaster.cast(this.buf).position(offset);
        if (offset > 0) {
            this.buf.compact();
            this.translateSavedIndexes(offset);
            this.position -= offset;
            BufferCaster.cast(this.buf).flip();
        } else {
            int newSize = this.buf.capacity() * 2;
            CharBuffer newBuf = CharBuffer.allocate(newSize);
            newBuf.put(this.buf);
            BufferCaster.cast(newBuf).flip();
            this.translateSavedIndexes(offset);
            this.position -= offset;
            this.buf = newBuf;
            this.matcher.reset(this.buf);
        }
    }

    private void translateSavedIndexes(int offset) {
        if (this.savedPosition != -1) {
            this.savedPosition -= offset;
        }
    }

    private void throwFor() {
        this.skipped = false;
        if (this.inputExhausted && this.position == this.buf.limit()) {
            throw new NoSuchElementException();
        }
        throw new InputMismatchException();
    }

    private boolean hasTokenInBuffer() {
        this.matcher.usePattern(this.delimPattern);
        this.matcher.region(this.position, this.buf.limit());
        if (this.matcher.lookingAt()) {
            this.position = this.matcher.end();
        }
        return this.position != this.buf.limit();
    }

    private String getCompleteTokenInBuffer() {
        this.matcher.usePattern(this.delimPattern);
        if (!this.skipped) {
            this.matcher.region(this.position, this.buf.limit());
            if (this.matcher.lookingAt()) {
                if (this.matcher.hitEnd() && !this.inputExhausted) {
                    this.needInput = true;
                    return null;
                }
                this.skipped = true;
                this.position = this.matcher.end();
            }
        }
        if (this.position == this.buf.limit()) {
            if (this.inputExhausted) {
                return null;
            }
            this.needInput = true;
            return null;
        }
        this.matcher.region(this.position, this.buf.limit());
        boolean foundNextDelim = this.matcher.find();
        if (foundNextDelim && this.matcher.end() == this.position) {
            foundNextDelim = this.matcher.find();
        }
        if (foundNextDelim) {
            if (this.matcher.requireEnd() && !this.inputExhausted) {
                this.needInput = true;
                return null;
            }
            int tokenEnd = this.matcher.start();
            this.matcher.usePattern(Scanner.cachePattern(FIND_ANY_PATTERN));
            this.matcher.region(this.position, tokenEnd);
            if (this.matcher.matches()) {
                String s = this.matcher.group();
                this.position = this.matcher.end();
                return s;
            }
            return null;
        }
        if (this.inputExhausted) {
            this.matcher.usePattern(Scanner.cachePattern(FIND_ANY_PATTERN));
            this.matcher.region(this.position, this.buf.limit());
            if (this.matcher.matches()) {
                String s = this.matcher.group();
                this.position = this.matcher.end();
                return s;
            }
            return null;
        }
        this.needInput = true;
        return null;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.source instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.source)).close();
                }
                catch (IOException e) {
                    this.lastIOException = e;
                }
            }
        }
        if (this.lastIOException != null) {
            throw this.lastIOException;
        }
    }

    private static Pattern cachePattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return CACHE.computeIfAbsent(pattern, Pattern::compile);
    }
}

