/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import io.undertow.server.handlers.form.EagerFormParsingHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.CamelUndertowHttpHandler;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowConstants;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowConsumer
extends DefaultConsumer
implements HttpHandler,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowConsumer.class);
    private CamelWebSocketHandler webSocketHandler;
    private boolean rest;
    private volatile boolean suspended;

    public UndertowConsumer(UndertowEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public boolean isHostedService() {
        return true;
    }

    public boolean isRest() {
        return this.rest;
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public UndertowEndpoint getEndpoint() {
        return (UndertowEndpoint)super.getEndpoint();
    }

    public List<String> computeAllowedRoles() {
        String allowedRolesString = this.getEndpoint().getAllowedRoles();
        if (allowedRolesString == null) {
            allowedRolesString = this.getEndpoint().getComponent().getAllowedRoles();
        }
        return allowedRolesString == null ? null : Arrays.asList(allowedRolesString.split("\\s*,\\s*"));
    }

    protected void doStart() throws Exception {
        this.suspended = false;
        super.doStart();
        UndertowEndpoint endpoint = this.getEndpoint();
        if (endpoint.isWebSocket()) {
            this.webSocketHandler = (CamelWebSocketHandler)endpoint.getComponent().registerEndpoint(this, endpoint.getHttpHandlerRegistrationInfo(), endpoint.getSslContext(), new CamelWebSocketHandler());
            this.webSocketHandler.setConsumer(this);
        } else {
            EagerFormParsingHandler httpHandler = new EagerFormParsingHandler().setNext((HttpHandler)this);
            if (endpoint.getAccessLog().booleanValue()) {
                Object accessLogReceiver = endpoint.getAccessLogReceiver() != null ? endpoint.getAccessLogReceiver() : new JBossLoggingAccessLogReceiver();
                httpHandler = new AccessLogHandler((HttpHandler)httpHandler, accessLogReceiver, "common", AccessLogHandler.class.getClassLoader());
            }
            if (endpoint.getHandlers() != null) {
                httpHandler = this.wrapHandler((HttpHandler)httpHandler, endpoint);
            }
            endpoint.getComponent().registerEndpoint(this, endpoint.getHttpHandlerRegistrationInfo(), endpoint.getSslContext(), (HttpHandler)Handlers.httpContinueRead((HttpHandler)httpHandler));
        }
    }

    protected void doStop() throws Exception {
        this.suspended = false;
        super.doStop();
        if (this.webSocketHandler != null) {
            this.webSocketHandler.setConsumer(null);
        }
        UndertowEndpoint endpoint = this.getEndpoint();
        endpoint.getComponent().unregisterEndpoint(this, endpoint.getHttpHandlerRegistrationInfo(), endpoint.getSslContext());
    }

    protected void doSuspend() throws Exception {
        this.suspended = true;
        super.doSuspend();
    }

    protected void doResume() throws Exception {
        this.suspended = false;
        super.doResume();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        HttpString requestMethod = httpExchange.getRequestMethod();
        if (Methods.OPTIONS.equals(requestMethod) && !this.getEndpoint().isOptionsEnabled()) {
            String allowedMethods = this.evalAllowedMethods();
            httpExchange.setStatusCode(200);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseHeaders().put(Headers.ALLOW, allowedMethods);
            httpExchange.endExchange();
            return;
        }
        if (httpExchange.isInIoThread()) {
            httpExchange.dispatch((HttpHandler)this);
            return;
        }
        if (this.isSuspended()) {
            httpExchange.setStatusCode(503);
            httpExchange.endExchange();
            return;
        }
        if (this.getEndpoint().getSecurityProvider() != null) {
            int statusCode = this.getEndpoint().getSecurityProvider().authenticate(httpExchange, this.computeAllowedRoles());
            if (statusCode != 200) {
                httpExchange.setStatusCode(statusCode);
                httpExchange.endExchange();
                return;
            }
        } else if (this.computeAllowedRoles() != null && !this.computeAllowedRoles().isEmpty()) {
            LOG.warn("Illegal state caused by missing securitProvider but existing allowed roles!");
            httpExchange.setStatusCode(403);
            httpExchange.endExchange();
            return;
        }
        Exchange camelExchange = this.createExchange(httpExchange);
        try {
            this.createUoW(camelExchange);
            this.getProcessor().process(camelExchange);
            this.sendResponse(httpExchange, camelExchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
        finally {
            this.doneUoW(camelExchange);
            this.releaseExchange(camelExchange, false);
        }
    }

    private String evalAllowedMethods() {
        StringJoiner methodsBuilder = new StringJoiner(",");
        Set<HttpHandlerRegistrationInfo> handlers = this.getEndpoint().getComponent().getHandlers();
        for (HttpHandlerRegistrationInfo reg : handlers) {
            URI uri = reg.getUri();
            if (reg.getMethodRestrict() == null || !this.getEndpoint().getHttpURI().equals(uri)) continue;
            String restrict = reg.getMethodRestrict();
            if (restrict.endsWith(",OPTIONS")) {
                restrict = restrict.substring(0, restrict.length() - 8);
            }
            methodsBuilder.add(restrict);
        }
        Object allowedMethods = methodsBuilder.toString();
        if (ObjectHelper.isEmpty((String)allowedMethods)) {
            allowedMethods = this.getEndpoint().getHttpMethodRestrict();
        }
        if (ObjectHelper.isEmpty((String)allowedMethods)) {
            allowedMethods = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
        }
        if (!((String)allowedMethods).contains("OPTIONS")) {
            allowedMethods = (String)allowedMethods + ",OPTIONS";
        }
        return allowedMethods;
    }

    private void sendResponse(HttpServerExchange httpExchange, Exchange camelExchange) throws IOException, NoTypeConversionAvailableException {
        block14: {
            Object body = this.getResponseBody(httpExchange, camelExchange);
            if (body == null) {
                LOG.trace("No payload to send as reply for exchange: {}", (Object)camelExchange);
                String contentType = (String)camelExchange.getIn().getHeader("Content-Type", MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"), String.class);
                httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, contentType);
                httpExchange.getResponseSender().send("");
                return;
            }
            if (this.getEndpoint().isUseStreaming() && body instanceof InputStream) {
                httpExchange.startBlocking();
                try (InputStream input = (InputStream)body;
                     OutputStream output = httpExchange.getOutputStream();){
                    IOHelper.copy((InputStream)input, (OutputStream)output, (int)16384, (boolean)true);
                    break block14;
                }
            }
            TypeConverter tc = this.getEndpoint().getCamelContext().getTypeConverter();
            ByteBuffer bodyAsByteBuffer = (ByteBuffer)tc.mandatoryConvertTo(ByteBuffer.class, body);
            httpExchange.getResponseSender().send(bodyAsByteBuffer);
        }
    }

    public void sendMessage(String connectionKey, WebSocketChannel channel, Object message) {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setHeader("websocket.connectionKey", (Object)connectionKey);
        if (channel != null) {
            exchange.getIn().setHeader("websocket.channel", (Object)channel);
        }
        exchange.getIn().setBody(message);
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    }

    public void sendEventNotification(String connectionKey, WebSocketHttpExchange transportExchange, WebSocketChannel channel, UndertowConstants.EventType eventType) {
        Exchange exchange = this.createExchange(true);
        Message in = exchange.getIn();
        in.setHeader("websocket.connectionKey", (Object)connectionKey);
        in.setHeader("websocket.eventType", (Object)eventType.getCode());
        in.setHeader("websocket.eventTypeEnum", (Object)eventType);
        if (channel != null) {
            in.setHeader("websocket.channel", (Object)channel);
        }
        if (transportExchange != null) {
            in.setHeader("websocket.exchange", (Object)transportExchange);
        }
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    }

    private Object getResponseBody(HttpServerExchange httpExchange, Exchange camelExchange) throws IOException {
        return this.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getMessage());
    }

    private HttpHandler wrapHandler(HttpHandler handler, UndertowEndpoint endpoint) {
        String[] handlders;
        HttpHandler nextHandler = handler;
        for (String obj : handlders = endpoint.getHandlers().split(",")) {
            if (EndpointHelper.isReferenceParameter((String)obj)) {
                obj = obj.substring(1);
            }
            CamelUndertowHttpHandler h = (CamelUndertowHttpHandler)CamelContextHelper.mandatoryLookup((CamelContext)endpoint.getCamelContext(), (String)obj, CamelUndertowHttpHandler.class);
            h.setNext(nextHandler);
            nextHandler = h;
        }
        return nextHandler;
    }

    private Exchange createExchange(HttpServerExchange httpExchange) throws Exception {
        Exchange exchange = this.createExchange(false);
        exchange.setPattern(ExchangePattern.InOut);
        Message in = this.getEndpoint().getUndertowHttpBinding().toCamelMessage(httpExchange, exchange);
        if (this.getEndpoint().getSecurityProvider() != null) {
            this.getEndpoint().getSecurityProvider().addHeader((key, value) -> in.setHeader(key, value), httpExchange);
        }
        exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)httpExchange.getRequestCharset());
        in.setHeader("CamelHttpCharacterEncoding", (Object)httpExchange.getRequestCharset());
        exchange.setIn(in);
        return exchange;
    }
}

