/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.undertow.UndertowConstants;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.handlers.ExtendedWebSocketCallback;
import org.apache.camel.converter.IOConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class CamelWebSocketHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CamelWebSocketHandler.class);
    private final UndertowWebSocketConnectionCallback callback;
    private UndertowConsumer consumer;
    private final Lock consumerLock = new ReentrantLock();
    private final WebSocketProtocolHandshakeHandler delegate;
    private final ChannelListener<WebSocketChannel> closeListener;
    private final UndertowReceiveListener receiveListener = new UndertowReceiveListener();

    public CamelWebSocketHandler() {
        this.callback = new UndertowWebSocketConnectionCallback();
        this.closeListener = channel -> this.sendEventNotificationIfNeeded((String)channel.getAttribute("websocket.connectionKey"), null, (WebSocketChannel)channel, UndertowConstants.EventType.ONCLOSE);
        this.delegate = Handlers.websocket((WebSocketConnectionCallback)this.callback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void send(WebSocketChannel channel, Object message, ExtendedWebSocketCallback callback, long timeoutMillis) throws IOException {
        if (channel.isOpen()) {
            if (message instanceof String) {
                WebSockets.sendText((String)((String)message), (WebSocketChannel)channel, (WebSocketCallback)callback);
                return;
            } else if (message instanceof byte[]) {
                ByteBuffer buffer = ByteBuffer.wrap((byte[])message);
                WebSockets.sendBinary((ByteBuffer)buffer, (WebSocketChannel)channel, (WebSocketCallback)callback, (long)timeoutMillis);
                return;
            } else if (message instanceof Reader) {
                Reader r = (Reader)message;
                WebSockets.sendText((String)IOConverter.toString((Reader)r), (WebSocketChannel)channel, (WebSocketCallback)callback);
                return;
            } else {
                if (!(message instanceof InputStream)) throw new RuntimeCamelException("Unexpected type of message " + message.getClass().getName() + "; expected String, byte[], " + Reader.class.getName() + " or " + InputStream.class.getName());
                InputStream in = (InputStream)message;
                ByteBuffer buffer = ByteBuffer.wrap(IOConverter.toBytes((InputStream)in));
                WebSockets.sendBinary((ByteBuffer)buffer, (WebSocketChannel)channel, (WebSocketCallback)callback, (long)timeoutMillis);
            }
            return;
        } else {
            callback.closedBeforeSent(channel);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.delegate.handleRequest(exchange);
    }

    public boolean send(Predicate<WebSocketChannel> peerFilter, Object message, int timeout, Exchange camelExchange, AsyncCallback camelCallback) throws IOException {
        List<WebSocketChannel> targetPeers = this.delegate.getPeerConnections().stream().filter(peerFilter).collect(Collectors.toList());
        if (targetPeers.isEmpty()) {
            camelCallback.done(true);
            return true;
        }
        MultiCallback wsCallback = new MultiCallback(targetPeers, camelCallback, camelExchange);
        for (WebSocketChannel peer : targetPeers) {
            CamelWebSocketHandler.send(peer, message, wsCallback, timeout);
        }
        return false;
    }

    public void setConsumer(UndertowConsumer consumer) {
        this.consumerLock.lock();
        try {
            if (consumer != null && this.consumer != null) {
                throw new IllegalStateException("Cannot call " + this.getClass().getName() + ".setConsumer(UndertowConsumer) with a non-null consumer before unsetting it via setConsumer(null)");
            }
            this.consumer = consumer;
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEventNotificationIfNeeded(String connectionKey, WebSocketHttpExchange transportExchange, WebSocketChannel channel, UndertowConstants.EventType eventType) {
        this.consumerLock.lock();
        try {
            if (this.consumer != null) {
                if (this.consumer.getEndpoint().isFireWebSocketChannelEvents()) {
                    this.consumer.sendEventNotification(connectionKey, transportExchange, channel, eventType);
                }
            } else {
                LOG.debug("No consumer to handle a peer {} event type {}", (Object)connectionKey, (Object)eventType);
            }
        }
        finally {
            this.consumerLock.unlock();
        }
    }

    class UndertowReceiveListener
    extends AbstractReceiveListener {
        UndertowReceiveListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
            LOG.debug("onFullBinaryMessage()");
            String connectionKey = (String)channel.getAttribute("websocket.connectionKey");
            if (connectionKey == null) {
                throw new RuntimeCamelException("websocket.connectionKey attribute not found on " + WebSocketChannel.class.getSimpleName() + " " + String.valueOf(channel));
            }
            Pooled data = message.getData();
            try {
                ByteBuffer[] buffers = (ByteBuffer[])data.getResource();
                int len = 0;
                for (ByteBuffer buffer : buffers) {
                    len += buffer.remaining();
                }
                byte[] bytes = new byte[len];
                int offset = 0;
                for (ByteBuffer buffer : buffers) {
                    int increment = buffer.remaining();
                    buffer.get(bytes, offset, increment);
                    offset += increment;
                }
                CamelWebSocketHandler.this.consumerLock.lock();
                try {
                    if (CamelWebSocketHandler.this.consumer != null) {
                        Object object;
                        if (CamelWebSocketHandler.this.consumer.getEndpoint().isUseStreaming()) {
                            ByteArrayInputStream byteArrayInputStream;
                            object = byteArrayInputStream;
                            byteArrayInputStream = new ByteArrayInputStream(bytes);
                        } else {
                            object = bytes;
                        }
                        Object outMsg = object;
                        CamelWebSocketHandler.this.consumer.sendMessage(connectionKey, channel, outMsg);
                    } else {
                        LOG.debug("No consumer to handle message received: {}", (Object)message);
                    }
                }
                finally {
                    CamelWebSocketHandler.this.consumerLock.unlock();
                }
            }
            finally {
                data.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
            String text = message.getData();
            LOG.debug("onFullTextMessage(): {}", (Object)text);
            String connectionKey = (String)channel.getAttribute("websocket.connectionKey");
            if (connectionKey == null) {
                throw new RuntimeCamelException("websocket.connectionKey attribute not found on " + WebSocketChannel.class.getSimpleName() + " " + String.valueOf(channel));
            }
            CamelWebSocketHandler.this.consumerLock.lock();
            try {
                if (CamelWebSocketHandler.this.consumer != null) {
                    Object outMsg = CamelWebSocketHandler.this.consumer.getEndpoint().isUseStreaming() ? new StringReader(text) : text;
                    CamelWebSocketHandler.this.consumer.sendMessage(connectionKey, channel, outMsg);
                } else {
                    LOG.debug("No consumer to handle message received: {}", (Object)message);
                }
            }
            finally {
                CamelWebSocketHandler.this.consumerLock.unlock();
            }
        }
    }

    class UndertowWebSocketConnectionCallback
    implements WebSocketConnectionCallback {
        public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
            LOG.trace("onConnect {}", (Object)exchange);
            String connectionKey = UUID.randomUUID().toString();
            channel.setAttribute("websocket.connectionKey", (Object)connectionKey);
            channel.getReceiveSetter().set((ChannelListener)CamelWebSocketHandler.this.receiveListener);
            channel.addCloseTask(CamelWebSocketHandler.this.closeListener);
            CamelWebSocketHandler.this.sendEventNotificationIfNeeded(connectionKey, exchange, channel, UndertowConstants.EventType.ONOPEN);
            channel.resumeReceives();
        }
    }

    static class MultiCallback
    implements ExtendedWebSocketCallback {
        private final AsyncCallback camelCallback;
        private final Exchange camelExchange;
        private Map<String, Throwable> errors;
        private final Lock lock = new ReentrantLock();
        private final Set<WebSocketChannel> peers;

        public MultiCallback(Collection<WebSocketChannel> peers, AsyncCallback camelCallback, Exchange camelExchange) {
            this.camelCallback = camelCallback;
            this.camelExchange = camelExchange;
            this.peers = new HashSet<WebSocketChannel>(peers);
        }

        @Override
        public void closedBeforeSent(WebSocketChannel channel) {
            this.lock.lock();
            try {
                this.peers.remove(channel);
                if (this.peers.isEmpty()) {
                    this.finish();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void complete(WebSocketChannel channel, Void context) {
            this.lock.lock();
            try {
                this.peers.remove(channel);
                if (this.peers.isEmpty()) {
                    this.finish();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void finish() {
            if (this.errors != null && !this.errors.isEmpty()) {
                if (this.errors.size() == 1) {
                    Map.Entry<String, Throwable> en = this.errors.entrySet().iterator().next();
                    String msg = "Delivery to the WebSocket peer " + en.getKey() + " channels has failed";
                    this.camelExchange.setException((Throwable)new CamelExchangeException(msg, this.camelExchange, en.getValue()));
                } else {
                    StringBuilder msg = new StringBuilder("Delivery to the following WebSocket peer channels has failed: ");
                    for (Map.Entry<String, Throwable> en : this.errors.entrySet()) {
                        msg.append("\n    ").append(en.getKey()).append(en.getValue().getMessage());
                    }
                    this.camelExchange.setException((Throwable)new CamelExchangeException(msg.toString(), this.camelExchange));
                }
            }
            this.camelCallback.done(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
            this.lock.lock();
            try {
                this.peers.remove(channel);
                String connectionKey = (String)channel.getAttribute("websocket.connectionKey");
                if (connectionKey == null) {
                    throw new RuntimeCamelException("websocket.connectionKey attribute not found on " + WebSocketChannel.class.getSimpleName() + " " + String.valueOf(channel));
                }
                if (this.errors == null) {
                    this.errors = new HashMap<String, Throwable>();
                }
                this.errors.put(connectionKey, throwable);
                if (this.peers.isEmpty()) {
                    this.finish();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

