/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.undertow.DefaultUndertowHost;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.RestUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.UndertowHostKey;
import org.apache.camel.component.undertow.UndertowHostOptions;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowRestHeaderFilterStrategy;
import org.apache.camel.component.undertow.spi.UndertowSecurityProvider;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.support.RestProducerFactoryHelper;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="undertow")
public class UndertowComponent
extends DefaultComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
RestProducerFactory,
SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowComponent.class);
    private final Map<UndertowHostKey, UndertowHost> undertowRegistry = new ConcurrentHashMap<UndertowHostKey, UndertowHost>();
    private final Set<HttpHandlerRegistrationInfo> handlers = new LinkedHashSet<HttpHandlerRegistrationInfo>();
    @Metadata(label="advanced")
    private UndertowHttpBinding undertowHttpBinding;
    @Metadata(label="security")
    private SSLContextParameters sslContextParameters;
    @Metadata(label="security")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="advanced")
    private UndertowHostOptions hostOptions;
    @Metadata(label="consumer")
    private boolean muteException;
    @Metadata(label="security")
    private Object securityConfiguration;
    @Metadata(label="security")
    private String allowedRoles;
    @Metadata(label="security")
    private UndertowSecurityProvider securityProvider;

    public UndertowComponent() {
        this(null);
    }

    public UndertowComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI uriHttpUriAddress = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, parameters);
        Map options = PropertiesHelper.extractProperties(parameters, (String)"option.");
        SSLContextParameters sslParams = this.sslContextParameters;
        if (sslParams == null) {
            sslParams = this.retrieveGlobalSslContextParameters();
        }
        UndertowEndpoint endpoint = this.createEndpointInstance(endpointUri, this);
        endpoint.setSslContextParameters(sslParams);
        endpoint.setMuteException(this.muteException);
        if (this.undertowHttpBinding == null) {
            this.undertowHttpBinding = this.getUndertowHttpBinding();
        }
        if (this.undertowHttpBinding != null) {
            endpoint.setUndertowHttpBinding(this.undertowHttpBinding);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        if (options != null) {
            endpoint.setOptions(options);
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpURI(httpUri);
        return endpoint;
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) {
        return new UndertowEndpoint(endpointUri.toString(), component);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    private void initSecurityProvider() throws Exception {
        Object securityConfiguration = this.getSecurityConfiguration();
        if (securityConfiguration != null) {
            ServiceLoader<UndertowSecurityProvider> securityProvider = ServiceLoader.load(UndertowSecurityProvider.class);
            Iterator<UndertowSecurityProvider> iter = securityProvider.iterator();
            LinkedList<String> providers = new LinkedList<String>();
            while (iter.hasNext()) {
                UndertowSecurityProvider security = iter.next();
                if (security.acceptConfiguration(securityConfiguration, null)) {
                    this.securityProvider = security;
                    LOG.info("Security provider found {}", (Object)securityProvider.getClass().getName());
                    break;
                }
                providers.add(security.getClass().getName());
            }
            if (this.securityProvider == null) {
                LOG.info("Security provider for configuration {} not found {}", securityConfiguration, providers);
            }
        }
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String contextPath;
        int num;
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, (String)this.getComponentName());
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((String)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((String)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + (String)path;
            }
        }
        if (ObjectHelper.isEmpty((String)host)) {
            host = RestComponentHelper.resolveRestHostName((String)host, (RestConfiguration)config);
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)this.getComponentName(), (RestConfiguration)config);
        String restrict = verb.toUpperCase(Locale.US);
        boolean explicitOptions = restrict.contains("OPTIONS");
        boolean cors = config.isEnableCORS();
        if (cors) {
            map.put("optionsEnabled", "true");
        } else if (explicitOptions) {
            map.put("optionsEnabled", "true");
        }
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (!explicitOptions ? 1 : 0) != 0);
        String url = RestComponentHelper.createRestConsumerUrl((String)this.getComponentName(), (String)scheme, (String)host, (int)port, (String)path, (Map)map);
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint(url, parameters);
        if (!map.containsKey("undertowHttpBinding")) {
            endpoint.setUndertowHttpBinding(new RestUndertowHttpBinding(endpoint.isUseStreaming()));
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        if (consumer instanceof UndertowConsumer) {
            ((UndertowConsumer)consumer).setRest(true);
        }
        return consumer;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        Object url = this.getComponentName() + ":" + host;
        if (!ObjectHelper.isEmpty((String)basePath)) {
            url = (String)url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((String)uriTemplate)) {
            url = (String)url + "/" + uriTemplate;
        }
        RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)this.getComponentName());
        HashMap map = new HashMap();
        if ((config.getProducerComponent() == null || config.getProducerComponent().equals(this.getComponentName())) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        url = HttpUtil.recreateUrl(map, (String)url);
        parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
        RestProducerFactoryHelper.setupComponentFor((String)url, (CamelContext)camelContext, (Map)((Map)parameters.remove("component")));
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint((String)url, parameters);
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new UndertowRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.securityProvider == null) {
            this.initSecurityProvider();
        }
        try {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)this.getComponentName());
            if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
                this.setProperties((Object)this, config.getComponentProperties());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public HttpHandler registerEndpoint(UndertowConsumer consumer, HttpHandlerRegistrationInfo registrationInfo, SSLContext sslContext, HttpHandler handler) throws Exception {
        URI uri = registrationInfo.getUri();
        UndertowHostKey key = new UndertowHostKey(uri.getHost(), uri.getPort(), sslContext);
        UndertowHost host = this.undertowRegistry.computeIfAbsent(key, this::createUndertowHost);
        host.validateEndpointURI(uri);
        this.handlers.add(registrationInfo);
        HttpHandler handlerWrapped = handler;
        if (this.securityProvider != null) {
            handlerWrapped = this.securityProvider.wrapHttpHandler(handler);
        }
        return host.registerHandler(consumer, registrationInfo, handlerWrapped);
    }

    public void unregisterEndpoint(UndertowConsumer consumer, HttpHandlerRegistrationInfo registrationInfo, SSLContext sslContext) {
        URI uri = registrationInfo.getUri();
        UndertowHostKey key = new UndertowHostKey(uri.getHost(), uri.getPort(), sslContext);
        UndertowHost host = this.undertowRegistry.get(key);
        this.handlers.remove(registrationInfo);
        if (host != null) {
            host.unregisterHandler(consumer, registrationInfo);
        }
    }

    protected UndertowHost createUndertowHost(UndertowHostKey key) {
        return new DefaultUndertowHost(key, this.hostOptions);
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public UndertowHostOptions getHostOptions() {
        return this.hostOptions;
    }

    public void setHostOptions(UndertowHostOptions hostOptions) {
        this.hostOptions = hostOptions;
    }

    public boolean isMuteException() {
        return this.muteException;
    }

    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> ((ComponentVerifierExtension)this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new)).verify(scope, parameters);
    }

    protected String getComponentName() {
        return "undertow";
    }

    public Set<HttpHandlerRegistrationInfo> getHandlers() {
        return this.handlers;
    }

    public Object getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(Object securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public String getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(String allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    public void setSecurityProvider(UndertowSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public UndertowSecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }
}

