/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.tracing.propagation.CamelHeadersExtractAdapter;
import org.apache.camel.tracing.propagation.CamelHeadersInjectAdapter;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public abstract class AbstractSpanDecorator
implements SpanDecorator {
    public static String stripSchemeAndOptions(Endpoint endpoint) {
        int start = endpoint.getEndpointUri().indexOf(58);
        ++start;
        while (endpoint.getEndpointUri().charAt(start) == '/') {
            ++start;
        }
        int end = endpoint.getEndpointUri().indexOf(63);
        return end == -1 ? endpoint.getEndpointUri().substring(start) : endpoint.getEndpointUri().substring(start, end);
    }

    public static Map<String, String> toQueryParameters(String uri) {
        int index = uri.indexOf(63);
        if (index != -1) {
            String queryString = uri.substring(index + 1);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : queryString.split("&")) {
                String[] parts = param.split("=");
                if (parts.length != 2) continue;
                map.put(parts[0], parts[1]);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static String getComponentName(Endpoint endpoint) {
        String answer;
        String string = answer = endpoint.getComponent() != null ? endpoint.getComponent().getDefaultName() : null;
        if (answer == null) {
            return AbstractSpanDecorator.getSchemeName(endpoint);
        }
        return answer;
    }

    private static String getSchemeName(Endpoint endpoint) {
        return StringHelper.before((String)endpoint.getEndpointUri(), (String)":");
    }

    @Override
    public boolean newSpan() {
        return true;
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return AbstractSpanDecorator.getComponentName(endpoint);
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        String routeId;
        String name = AbstractSpanDecorator.getComponentName(endpoint);
        span.setComponent("camel-" + name);
        String scheme = AbstractSpanDecorator.getSchemeName(endpoint);
        span.setTag("url.scheme", scheme);
        if (exchange != null && (routeId = exchange.getFromRouteId()) != null) {
            span.setTag("camel.route.id", routeId);
        }
        String uri = endpoint.toString();
        span.setTag("camel.uri", uri);
        span.setTag("url.path", AbstractSpanDecorator.stripSchemeAndOptions(endpoint));
        String query = URISupport.extractQuery((String)uri);
        if (query != null) {
            span.setTag("url.query", query);
        }
        if (endpoint instanceof EndpointServiceLocation) {
            Map map;
            String ap;
            EndpointServiceLocation ela = (EndpointServiceLocation)endpoint;
            String adr = ela.getServiceUrl();
            if (adr != null) {
                span.setTag("server.address", adr);
            }
            if ((ap = ela.getServiceProtocol()) != null) {
                span.setTag("server.protocol", ap);
            }
            if ((map = ela.getServiceMetadata()) != null) {
                String region;
                String id;
                String un = (String)map.get("username");
                if (un != null) {
                    span.setTag("user.name", un);
                }
                if ((id = (String)map.get("clientId")) != null) {
                    span.setTag("user.id", id);
                }
                if ((region = (String)map.get("region")) != null) {
                    span.setTag("server.region", region);
                }
            }
        }
    }

    @Override
    public void post(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        if (exchange.isFailed()) {
            span.setError(true);
            if (exchange.getException() != null) {
                HashMap<String, String> logEvent = new HashMap<String, String>();
                logEvent.put("event", "error");
                logEvent.put("error.kind", "Exception");
                logEvent.put("message", exchange.getException().getMessage());
                span.log(logEvent);
            }
        }
    }

    @Override
    public SpanKind getInitiatorSpanKind() {
        return SpanKind.SPAN_KIND_CLIENT;
    }

    @Override
    public SpanKind getReceiverSpanKind() {
        return SpanKind.SPAN_KIND_SERVER;
    }

    @Override
    public ExtractAdapter getExtractAdapter(Map<String, Object> map, boolean encoding) {
        return new CamelHeadersExtractAdapter(map);
    }

    @Override
    public InjectAdapter getInjectAdapter(Map<String, Object> map, boolean encoding) {
        return new CamelHeadersInjectAdapter(map);
    }
}

