/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.metrics.invoker.auth;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.component.torchserve.client.metrics.invoker.Pair;
import org.apache.camel.component.torchserve.client.metrics.invoker.auth.Authentication;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private Supplier<String> tokenSupplier;

    public HttpBearerAuth(String scheme) {
        this.scheme = HttpBearerAuth.upperCaseBearer(scheme);
    }

    public String getBearerToken() {
        return this.tokenSupplier.get();
    }

    public void setBearerToken(String bearerToken) {
        this.tokenSupplier = () -> bearerToken;
    }

    public void setBearerToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        String bearerToken;
        String string = bearerToken = this.tokenSupplier != null ? this.tokenSupplier.get() : null;
        if (bearerToken == null) {
            return;
        }
        headerParams.put("Authorization", (String)(this.scheme != null ? this.scheme + " " : "") + bearerToken);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

