/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.impl;

import java.util.List;
import java.util.Map;
import org.apache.camel.component.torchserve.client.Management;
import org.apache.camel.component.torchserve.client.management.api.DefaultApi;
import org.apache.camel.component.torchserve.client.management.invoker.ApiClient;
import org.apache.camel.component.torchserve.client.management.invoker.ApiException;
import org.apache.camel.component.torchserve.client.management.model.DescribeModel200ResponseInner;
import org.apache.camel.component.torchserve.client.model.Api;
import org.apache.camel.component.torchserve.client.model.ModelDetail;
import org.apache.camel.component.torchserve.client.model.ModelList;
import org.apache.camel.component.torchserve.client.model.RegisterOptions;
import org.apache.camel.component.torchserve.client.model.Response;
import org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions;
import org.apache.camel.component.torchserve.client.model.UnregisterOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagement
implements Management {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagement.class);
    private final DefaultApi api;

    public DefaultManagement() {
        this(8081);
    }

    public DefaultManagement(int port) {
        this("http://localhost:" + port);
    }

    public DefaultManagement(String address) {
        ApiClient client = new ApiClient().setBasePath(address);
        this.api = new DefaultApi(client);
        LOG.debug("Management API address: {}", (Object)address);
    }

    public void setAuthToken(String token) {
        this.api.getApiClient().addDefaultHeader("Authorization", "Bearer " + token);
    }

    @Override
    public Response registerModel(String url, RegisterOptions options) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.registerModel(url, options.getModelName(), options.getHandler(), options.getRuntime(), options.getBatchSize(), options.getMaxBatchDelay(), options.getResponseTimeout(), options.getStartupTimeout(), options.getInitialWorkers(), options.getSynchronous(), options.getS3SseKms(), null));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Response setAutoScale(String modelName, ScaleWorkerOptions options) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.setAutoScale(modelName, options.getMinWorker(), options.getMaxWorker(), options.getNumberGpu(), options.getSynchronous(), options.getTimeout()));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Response setAutoScale(String modelName, String modelVersion, ScaleWorkerOptions options) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.versionSetAutoScale(modelName, modelVersion, options.getMinWorker(), options.getMaxWorker(), options.getNumberGpu(), options.getSynchronous(), options.getTimeout()));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public List<ModelDetail> describeModel(String modelName) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            List<DescribeModel200ResponseInner> response = this.api.describeModel(modelName);
            return response.stream().map(ModelDetail::from).toList();
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public List<ModelDetail> describeModel(String modelName, String modelVersion) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            List<DescribeModel200ResponseInner> response = this.api.versionDescribeModel(modelName, modelVersion);
            return response.stream().map(ModelDetail::from).toList();
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Response unregisterModel(String modelName, UnregisterOptions options) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.unregisterModel(modelName, options.getSynchronous(), options.getTimeout()));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Response unregisterModel(String modelName, String modelVersion, UnregisterOptions options) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.versionUnregisterModel(modelName, modelVersion, options.getSynchronous(), options.getTimeout()));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public ModelList listModels(Integer limit, String nextPageToken) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return ModelList.from(this.api.listModels(limit, nextPageToken));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Response setDefault(String modelName, String modelVersion) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.setDefault(modelName, modelVersion));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Api apiDescription() throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Api.from(this.api.apiDescription(Map.of("Content-Type", "application/json")));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Object token(String type) throws org.apache.camel.component.torchserve.client.model.ApiException {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

