/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.producer;

import java.util.List;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.torchserve.TorchServeConfiguration;
import org.apache.camel.component.torchserve.TorchServeEndpoint;
import org.apache.camel.component.torchserve.client.Management;
import org.apache.camel.component.torchserve.client.model.ApiException;
import org.apache.camel.component.torchserve.client.model.ModelDetail;
import org.apache.camel.component.torchserve.client.model.ModelList;
import org.apache.camel.component.torchserve.client.model.RegisterOptions;
import org.apache.camel.component.torchserve.client.model.Response;
import org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions;
import org.apache.camel.component.torchserve.client.model.UnregisterOptions;
import org.apache.camel.component.torchserve.producer.TorchServeProducer;

public class ManagementProducer
extends TorchServeProducer {
    private final Management management;
    private final String operation;

    public ManagementProducer(TorchServeEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.management = endpoint.getClient().management();
        this.operation = endpoint.getOperation();
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.operation) {
            case "register": {
                this.register(exchange);
                break;
            }
            case "scale-worker": {
                this.scaleWorker(exchange);
                break;
            }
            case "describe": {
                this.describe(exchange);
                break;
            }
            case "unregister": {
                this.unregister(exchange);
                break;
            }
            case "list": {
                this.list(exchange);
                break;
            }
            case "set-default": {
                this.setDefault(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + this.operation);
            }
        }
    }

    private void register(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String url = Optional.ofNullable((String)message.getHeader("CamelTorchServeUrl", String.class)).orElse(configuration.getUrl());
        RegisterOptions options = Optional.ofNullable((RegisterOptions)message.getHeader("CamelTorchServeRegisterOptions", RegisterOptions.class)).or(() -> Optional.ofNullable(configuration.getRegisterOptions())).orElse(RegisterOptions.empty());
        Response response = this.management.registerModel(url, options);
        message.setBody((Object)response.getStatus());
    }

    private void scaleWorker(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String modelName = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelName", String.class)).orElse(configuration.getModelName());
        ScaleWorkerOptions options = Optional.ofNullable((ScaleWorkerOptions)message.getHeader("CamelTorchServeScaleWorkerOptions", ScaleWorkerOptions.class)).or(() -> Optional.ofNullable(configuration.getScaleWorkerOptions())).orElse(ScaleWorkerOptions.empty());
        Response response = this.management.setAutoScale(modelName, options);
        message.setBody((Object)response.getStatus());
    }

    private void describe(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String modelName = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelName", String.class)).orElse(configuration.getModelName());
        String modelVersion = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelVersion", String.class)).orElse(configuration.getModelVersion());
        List<ModelDetail> response = modelVersion == null ? this.management.describeModel(modelName) : this.management.describeModel(modelName, modelVersion);
        message.setBody(response);
    }

    private void unregister(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String modelName = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelName", String.class)).orElse(configuration.getModelName());
        String modelVersion = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelVersion", String.class)).orElse(configuration.getModelVersion());
        UnregisterOptions options = Optional.ofNullable((UnregisterOptions)message.getHeader("CamelTorchServeUnrsegisterOptions", UnregisterOptions.class)).or(() -> Optional.ofNullable(configuration.getUnregisterOptions())).orElse(UnregisterOptions.empty());
        Response response = modelVersion == null ? this.management.unregisterModel(modelName, options) : this.management.unregisterModel(modelName, modelVersion, options);
        message.setBody((Object)response.getStatus());
    }

    private void list(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        int limit = Optional.ofNullable((Integer)message.getHeader("CamelTorchServeListLimit", Integer.class)).orElse(configuration.getListLimit());
        String nextPageToken = Optional.ofNullable((String)message.getHeader("CamelTorchServeListNextPageToken", String.class)).orElse(configuration.getListNextPageToken());
        ModelList response = this.management.listModels(limit, nextPageToken);
        message.setBody((Object)response);
    }

    private void setDefault(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String modelName = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelName", String.class)).orElse(configuration.getModelName());
        String modelVersion = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelVersion", String.class)).orElse(configuration.getModelVersion());
        Response response = this.management.setDefault(modelName, modelVersion);
        message.setBody((Object)response.getStatus());
    }
}

