/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.impl;

import java.util.Map;
import org.apache.camel.component.torchserve.client.Inference;
import org.apache.camel.component.torchserve.client.inference.api.DefaultApi;
import org.apache.camel.component.torchserve.client.inference.invoker.ApiClient;
import org.apache.camel.component.torchserve.client.inference.invoker.ApiException;
import org.apache.camel.component.torchserve.client.model.Api;
import org.apache.camel.component.torchserve.client.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInference
implements Inference {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInference.class);
    private final DefaultApi api;

    public DefaultInference() {
        this(8080);
    }

    public DefaultInference(int port) {
        this("http://localhost:" + port);
    }

    public DefaultInference(String address) {
        ApiClient client = new ApiClient().setBasePath(address);
        this.api = new DefaultApi(client);
        LOG.debug("Inference API address: {}", (Object)address);
    }

    public void setAuthToken(String token) {
        this.api.getApiClient().addDefaultHeader("Authorization", "Bearer " + token);
    }

    @Override
    public Api apiDescription() throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Api.from(this.api.apiDescription(Map.of("Content-Type", "application/json")));
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Response ping() throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return Response.from(this.api.ping());
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Object predictions(String modelName, Object body) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return this.api.predictions_1(modelName, body);
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Object predictions(String modelName, String modelVersion, Object body) throws org.apache.camel.component.torchserve.client.model.ApiException {
        try {
            return this.api.versionPredictions(modelName, modelVersion, body);
        }
        catch (ApiException e) {
            throw new org.apache.camel.component.torchserve.client.model.ApiException(e);
        }
    }

    @Override
    public Object explanations(String modelName) {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

