/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.producer;

import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.torchserve.TorchServeConfiguration;
import org.apache.camel.component.torchserve.TorchServeEndpoint;
import org.apache.camel.component.torchserve.client.Metrics;
import org.apache.camel.component.torchserve.client.model.ApiException;
import org.apache.camel.component.torchserve.producer.TorchServeProducer;

public class MetricsProducer
extends TorchServeProducer {
    private final Metrics metrics;
    private final String operation;

    public MetricsProducer(TorchServeEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.metrics = endpoint.getClient().metrics();
        this.operation = endpoint.getOperation();
    }

    public void process(Exchange exchange) throws Exception {
        if (!"metrics".equals(this.operation)) {
            throw new IllegalArgumentException("Unsupported operation: " + this.operation);
        }
        this.metrics(exchange);
    }

    private void metrics(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String metricsName = Optional.ofNullable((String)message.getHeader("CamelTorchServeMetricsName", String.class)).orElse(configuration.getMetricsName());
        String response = metricsName == null ? this.metrics.metrics() : this.metrics.metrics(metricsName);
        message.setBody((Object)response);
    }
}

