/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.model;

public class RegisterOptions {
    private String modelName = null;
    private String handler = null;
    private String runtime = null;
    private Integer batchSize = null;
    private Integer maxBatchDelay = null;
    private Integer responseTimeout = null;
    private Integer startupTimeout = null;
    private Integer initialWorkers = null;
    private Boolean synchronous = null;
    private Boolean s3SseKms = null;

    private RegisterOptions() {
    }

    public static RegisterOptions empty() {
        return new RegisterOptions();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public Integer getStartupTimeout() {
        return this.startupTimeout;
    }

    public Integer getInitialWorkers() {
        return this.initialWorkers;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public Boolean getS3SseKms() {
        return this.s3SseKms;
    }

    public static class Builder {
        private final RegisterOptions options = new RegisterOptions();

        public Builder modelName(String modelName) {
            this.options.modelName = modelName;
            return this;
        }

        public Builder handler(String handler) {
            this.options.handler = handler;
            return this;
        }

        public Builder runtime(String runtime) {
            this.options.runtime = runtime;
            return this;
        }

        public Builder batchSize(Integer batchSize) {
            this.options.batchSize = batchSize;
            return this;
        }

        public Builder maxBatchDelay(Integer maxBatchDelay) {
            this.options.maxBatchDelay = maxBatchDelay;
            return this;
        }

        public Builder responseTimeout(Integer responseTimeout) {
            this.options.responseTimeout = responseTimeout;
            return this;
        }

        public Builder startupTimeout(Integer startupTimeout) {
            this.options.startupTimeout = startupTimeout;
            return this;
        }

        public Builder initialWorkers(Integer initialWorkers) {
            this.options.initialWorkers = initialWorkers;
            return this;
        }

        public Builder synchronous(Boolean synchronous) {
            this.options.synchronous = synchronous;
            return this;
        }

        public Builder s3SseKms(Boolean s3SseKms) {
            this.options.s3SseKms = s3SseKms;
            return this;
        }

        public RegisterOptions build() {
            return this.options;
        }
    }
}

