/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.torchserve.TorchServeComponent;
import org.apache.camel.component.torchserve.TorchServeConfiguration;
import org.apache.camel.component.torchserve.TorchServeConstants;
import org.apache.camel.component.torchserve.client.TorchServeClient;
import org.apache.camel.component.torchserve.producer.InferenceProducer;
import org.apache.camel.component.torchserve.producer.ManagementProducer;
import org.apache.camel.component.torchserve.producer.MetricsProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.9.0", scheme="torchserve", title="TorchServe", syntax="torchserve:api/operation", producerOnly=true, category={Category.AI}, headersClass=TorchServeConstants.class)
public class TorchServeEndpoint
extends DefaultEndpoint {
    @UriPath(enums="inference,management,metrics", description="The TorchServe API")
    @Metadata(required=true)
    private final String api;
    @UriPath(enums="ping,predictions,explanations,register,scale-worker,describe,unregister,list,set-default,metrics", description="The API operation")
    @Metadata(required=true)
    private final String operation;
    @UriParam
    private TorchServeConfiguration configuration;
    private TorchServeClient client;

    public TorchServeEndpoint(String uri, TorchServeComponent component, String path, TorchServeConfiguration configuration) {
        super(uri, (Component)component);
        String[] parts = TorchServeEndpoint.extractPath(path);
        this.api = parts[0];
        this.operation = parts[1];
        this.configuration = configuration;
    }

    private static String[] extractPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        String[] parts = path.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("path must be <api>/<operation>: " + path);
        }
        return parts;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.client = this.createClient();
    }

    private TorchServeClient createClient() {
        TorchServeClient.Builder builder = TorchServeClient.builder();
        if (this.configuration.getInferenceKey() != null) {
            builder.inferenceKey(this.configuration.getInferenceKey());
        }
        if (this.configuration.getInferenceAddress() != null) {
            builder.inferenceAddress(this.configuration.getInferenceAddress());
        } else {
            builder.inferencePort(this.configuration.getInferencePort());
        }
        if (this.configuration.getManagementKey() != null) {
            builder.managementKey(this.configuration.getManagementKey());
        }
        if (this.configuration.getManagementAddress() != null) {
            builder.managementAddress(this.configuration.getManagementAddress());
        } else {
            builder.managementPort(this.configuration.getManagementPort());
        }
        if (this.configuration.getMetricsAddress() != null) {
            builder.metricsAddress(this.configuration.getMetricsAddress());
        } else {
            builder.metricsPort(this.configuration.getMetricsPort());
        }
        return builder.build();
    }

    public Producer createProducer() {
        return switch (this.api) {
            case "inference" -> new InferenceProducer(this);
            case "management" -> new ManagementProducer(this);
            case "metrics" -> new MetricsProducer(this);
            default -> throw new IllegalArgumentException("Unknown API: " + this.api);
        };
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public String getApi() {
        return this.api;
    }

    public String getOperation() {
        return this.operation;
    }

    public TorchServeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TorchServeConfiguration configuration) {
        this.configuration = configuration;
    }

    public TorchServeClient getClient() {
        return this.client;
    }
}

