/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.torchserve.client.management.model.DescribeModel200ResponseInner;
import org.apache.camel.component.torchserve.client.model.JobQueueStatus;
import org.apache.camel.component.torchserve.client.model.Metrics;
import org.apache.camel.component.torchserve.client.model.Model;
import org.apache.camel.component.torchserve.client.model.Worker;

public class ModelDetail
extends Model {
    private String modelVersion = null;
    private Integer minWorkers = null;
    private Integer maxWorkers = null;
    private Integer batchSize = null;
    private Integer maxBatchDelay = null;
    private String status = null;
    private List<Worker> workers = new ArrayList<Worker>();
    private Metrics metrics = null;
    private JobQueueStatus jobQueueStatus = null;

    public static ModelDetail from(DescribeModel200ResponseInner src) {
        ModelDetail model = new ModelDetail();
        model.setModelName(src.getModelName());
        model.setModelVersion(src.getModelVersion());
        model.setModelUrl(src.getModelUrl());
        model.setMinWorkers(src.getMinWorkers());
        model.setMaxWorkers(src.getMaxWorkers());
        model.setBatchSize(src.getBatchSize());
        model.setMaxBatchDelay(src.getMaxBatchDelay());
        model.setStatus(src.getStatus());
        model.setWorkers(src.getWorkers().stream().map(Worker::from).toList());
        model.setMetrics(Metrics.from(src.getMetrics()));
        model.setJobQueueStatus(JobQueueStatus.from(src.getJobQueueStatus()));
        return model;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public Integer getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(Integer minWorkers) {
        this.minWorkers = minWorkers;
    }

    public Integer getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(Integer maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public void setMaxBatchDelay(Integer maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Worker> getWorkers() {
        return this.workers;
    }

    public void setWorkers(List<Worker> workers) {
        this.workers = workers;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public JobQueueStatus getJobQueueStatus() {
        return this.jobQueueStatus;
    }

    public void setJobQueueStatus(JobQueueStatus jobQueueStatus) {
        this.jobQueueStatus = jobQueueStatus;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {\n    modelName: " + this.modelName + "\n    modelVersion: " + this.modelVersion + "\n    modelUrl: " + this.modelUrl + "\n    minWorkers: " + this.minWorkers + "\n    maxWorkers: " + this.maxWorkers + "\n    batchSize: " + this.batchSize + "\n    maxBatchDelay: " + this.maxBatchDelay + "\n    status: " + this.status + "\n    workers: " + String.valueOf(this.workers) + "\n    metrics: " + String.valueOf(this.metrics) + "\n    jobQueueStatus: " + String.valueOf(this.jobQueueStatus) + "\n}";
    }
}

