/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

public final class Version
implements Comparable<Version> {
    private final String version;

    public Version(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMajor() {
        String[] thisParts = this.getVersion().split("\\.");
        return thisParts[0];
    }

    public String getMinor() {
        String[] thisParts = this.getVersion().split("\\.");
        if (thisParts.length > 1) {
            return thisParts[1];
        }
        return null;
    }

    public String getPatch() {
        String[] thisParts = this.getVersion().split("\\.");
        if (thisParts.length > 2) {
            return thisParts[2];
        }
        return null;
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        String[] thisParts = this.getVersion().split("\\.");
        String[] thatParts = that.getVersion().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            long thatPart;
            long thisPart = i < thisParts.length ? Long.parseLong(thisParts[i]) : 0L;
            long l = thatPart = i < thatParts.length ? Long.parseLong(thatParts[i]) : 0L;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public String prevMinor() {
        int patch;
        String[] parts = this.getVersion().split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int n = patch = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
        if (minor > 0) {
            --minor;
        }
        return major + "." + minor + "." + patch;
    }

    public String toString() {
        return this.version;
    }
}

