/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.ApiMethodModel;
import org.apache.camel.tooling.model.ApiModel;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.DevConsoleModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.PojoBeanModel;
import org.apache.camel.tooling.model.ReleaseModel;
import org.apache.camel.tooling.model.Strings;
import org.apache.camel.tooling.model.SupportLevel;
import org.apache.camel.tooling.model.TransformerModel;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class JsonMapper {
    private JsonMapper() {
    }

    public static BaseModel<?> generateModel(Path file) {
        try {
            String json = Files.readString(file);
            return JsonMapper.generateModel(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading json file: " + String.valueOf(file), e);
        }
    }

    public static BaseModel<?> generateModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateModel(obj);
    }

    public static BaseModel<?> generateModel(JsonObject obj) {
        if (obj.containsKey((Object)"component")) {
            return JsonMapper.generateComponentModel(obj);
        }
        if (obj.containsKey((Object)"language")) {
            return JsonMapper.generateLanguageModel(obj);
        }
        if (obj.containsKey((Object)"dataformat")) {
            return JsonMapper.generateDataFormatModel(obj);
        }
        if (obj.containsKey((Object)"transformer")) {
            return JsonMapper.generateTransformerModel(obj);
        }
        if (obj.containsKey((Object)"console")) {
            return JsonMapper.generateDevConsoleModel(obj);
        }
        if (obj.containsKey((Object)"other")) {
            return JsonMapper.generateOtherModel(obj);
        }
        if (obj.containsKey((Object)"model")) {
            return JsonMapper.generateEipModel(obj);
        }
        if (obj.containsKey((Object)"bean")) {
            return JsonMapper.generatePojoBeanModel(obj);
        }
        return null;
    }

    public static ComponentModel generateComponentModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateComponentModel(obj);
    }

    public static ComponentModel generateComponentModel(JsonObject obj) {
        ApiMethodModel amm;
        ApiModel am;
        JsonObject mprap;
        JsonObject mprp;
        JsonObject headers;
        JsonObject mobj = (JsonObject)obj.get((Object)"component");
        ComponentModel model = new ComponentModel();
        JsonMapper.parseComponentModel(mobj, model);
        JsonObject mcprp = (JsonObject)obj.get((Object)"componentProperties");
        if (mcprp != null) {
            for (Object entry : mcprp.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                ComponentModel.ComponentOptionModel option = new ComponentModel.ComponentOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addComponentOption(option);
            }
        }
        if ((headers = (JsonObject)obj.get((Object)"headers")) != null) {
            for (Object entry : headers.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                ComponentModel.EndpointHeaderModel header = new ComponentModel.EndpointHeaderModel();
                JsonMapper.parseOption(mp, header, (String)entry.getKey());
                header.setConstantName(mp.getString("constantName"));
                model.addEndpointHeader(header);
            }
        }
        if ((mprp = (JsonObject)obj.get((Object)"properties")) != null) {
            for (Map.Entry entry : mprp.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                ComponentModel.EndpointOptionModel option = new ComponentModel.EndpointOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addEndpointOption(option);
            }
        }
        if ((mprap = (JsonObject)obj.get((Object)"apis")) != null) {
            for (Map.Entry entry : mprap.entrySet()) {
                JsonObject mm;
                String name = (String)entry.getKey();
                JsonObject mp = (JsonObject)entry.getValue();
                am = new ApiModel();
                am.setName(name);
                am.setDescription(mp.getStringOrDefault("description", ""));
                am.setConsumerOnly(mp.getBooleanOrDefault("consumerOnly", false));
                am.setProducerOnly(mp.getBooleanOrDefault("producerOnly", false));
                model.getApiOptions().add(am);
                Collection aliases = mp.getCollection("aliases");
                if (aliases != null && !aliases.isEmpty()) {
                    aliases.forEach(am::addAlias);
                }
                if ((mm = (JsonObject)mp.get((Object)"methods")) == null) continue;
                for (Map.Entry mme : mm.entrySet()) {
                    JsonObject mmp = (JsonObject)mme.getValue();
                    amm = am.newMethod((String)mme.getKey());
                    Collection signatures = mmp.getCollection("signatures");
                    if (signatures != null && !signatures.isEmpty()) {
                        signatures.forEach(amm::addSignature);
                    }
                    amm.setDescription(mmp.getStringOrDefault("description", ""));
                }
            }
        }
        if ((mprap = (JsonObject)obj.get((Object)"apiProperties")) != null) {
            for (Map.Entry entry : mprap.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                String name = (String)entry.getKey();
                am = model.getApiOptions().stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
                if (am == null) {
                    throw new RuntimeException("Invalid json. Cannot find ApiModel with name: " + name);
                }
                JsonObject mm = (JsonObject)mp.get((Object)"methods");
                if (mm == null) continue;
                for (Map.Entry mme : mm.entrySet()) {
                    JsonObject mmp = (JsonObject)mme.getValue();
                    String mname = (String)mme.getKey();
                    amm = am.getMethods().stream().filter(a -> a.getName().equals(mname)).findFirst().orElse(null);
                    if (amm == null) {
                        throw new RuntimeException("Invalid json. Cannot find ApiMethodModel with name: " + mname);
                    }
                    JsonObject properties = (JsonObject)mmp.get((Object)"properties");
                    if (properties == null) continue;
                    for (Map.Entry pe : properties.entrySet()) {
                        JsonObject prop = (JsonObject)pe.getValue();
                        ComponentModel.ApiOptionModel option = new ComponentModel.ApiOptionModel();
                        JsonMapper.parseOption(prop, option, (String)pe.getKey());
                        option.setOptional(prop.getBooleanOrDefault("optional", false));
                        amm.addApiOptionModel(option);
                    }
                }
            }
        }
        return model;
    }

    public static void parseComponentModel(JsonObject mobj, ComponentModel model) {
        JsonMapper.parseModel(mobj, model);
        model.setScheme(mobj.getString("scheme"));
        model.setExtendsScheme(mobj.getString("extendsScheme"));
        model.setAlternativeSchemes(mobj.getString("alternativeSchemes"));
        model.setSyntax(mobj.getString("syntax"));
        model.setAlternativeSyntax(mobj.getString("alternativeSyntax"));
        model.setAsync(mobj.getBooleanOrDefault("async", false));
        model.setApi(mobj.getBooleanOrDefault("api", false));
        model.setApiSyntax(mobj.getString("apiSyntax"));
        model.setConsumerOnly(mobj.getBooleanOrDefault("consumerOnly", false));
        model.setProducerOnly(mobj.getBooleanOrDefault("producerOnly", false));
        model.setLenientProperties(mobj.getBooleanOrDefault("lenientProperties", false));
        model.setRemote(mobj.getBooleanOrDefault("remote", false));
        JsonMapper.parseArtifact(mobj, model);
    }

    private static void parseArtifact(JsonObject mobj, ArtifactModel<?> model) {
        model.setGroupId(mobj.getString("groupId"));
        model.setArtifactId(mobj.getString("artifactId"));
        model.setVersion(mobj.getString("version"));
    }

    public static String createParameterJsonSchema(ComponentModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(ComponentModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put((Object)"scheme", (Object)model.getScheme());
        obj.put((Object)"extendsScheme", (Object)model.getExtendsScheme());
        obj.put((Object)"alternativeSchemes", (Object)model.getAlternativeSchemes());
        obj.put((Object)"syntax", (Object)model.getSyntax());
        obj.put((Object)"alternativeSyntax", (Object)model.getAlternativeSyntax());
        obj.put((Object)"async", (Object)model.isAsync());
        obj.put((Object)"api", (Object)model.isApi());
        if (model.isApi()) {
            obj.put((Object)"apiSyntax", (Object)model.getApiSyntax());
        }
        obj.put((Object)"consumerOnly", (Object)model.isConsumerOnly());
        obj.put((Object)"producerOnly", (Object)model.isProducerOnly());
        obj.put((Object)"lenientProperties", (Object)model.isLenientProperties());
        obj.put((Object)"remote", (Object)model.isRemote());
        obj.put((Object)"verifiers", (Object)model.getVerifiers());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"component", (Object)obj);
        wrapper.put((Object)"componentProperties", (Object)JsonMapper.asJsonObject(model.getComponentOptions()));
        List<ComponentModel.EndpointHeaderModel> headers = model.getEndpointHeaders();
        if (!headers.isEmpty()) {
            wrapper.put((Object)"headers", (Object)JsonMapper.asJsonObject(headers));
        }
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getEndpointOptions()));
        if (!model.getApiOptions().isEmpty()) {
            wrapper.put((Object)"apis", (Object)JsonMapper.apiModelAsJsonObject(model.getApiOptions(), false));
            wrapper.put((Object)"apiProperties", (Object)JsonMapper.apiModelAsJsonObject(model.getApiOptions(), true));
        }
        return wrapper;
    }

    public static DataFormatModel generateDataFormatModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateDataFormatModel(obj);
    }

    public static DataFormatModel generateDataFormatModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"dataformat");
        DataFormatModel model = new DataFormatModel();
        JsonMapper.parseModel(mobj, model);
        JsonMapper.parseArtifact(mobj, model);
        model.setModelName(mobj.getString("modelName"));
        model.setModelJavaType(mobj.getString("modelJavaType"));
        JsonObject mprp = (JsonObject)obj.get((Object)"properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            DataFormatModel.DataFormatOptionModel option = new DataFormatModel.DataFormatOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(DataFormatModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(DataFormatModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put((Object)"modelName", (Object)model.getModelName());
        obj.put((Object)"modelJavaType", (Object)model.getModelJavaType());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"dataformat", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static EipModel generateEipModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateEipModel(obj);
    }

    public static EipModel generateEipModel(JsonObject obj) {
        EipModel.EipOptionModel option;
        JsonObject mp;
        JsonObject mobj = (JsonObject)obj.get((Object)"model");
        EipModel model = new EipModel();
        JsonMapper.parseModel(mobj, model);
        model.setAbstractModel(mobj.getBooleanOrDefault("abstract", false));
        model.setInput(mobj.getBooleanOrDefault("input", false));
        model.setOutput(mobj.getBooleanOrDefault("output", false));
        JsonObject mprp = (JsonObject)obj.get((Object)"properties");
        if (mprp != null) {
            for (Map.Entry entry : mprp.entrySet()) {
                mp = (JsonObject)entry.getValue();
                option = new EipModel.EipOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addOption(option);
            }
        }
        if ((mprp = (JsonObject)obj.get((Object)"exchangeProperties")) != null) {
            for (Map.Entry entry : mprp.entrySet()) {
                mp = (JsonObject)entry.getValue();
                option = new EipModel.EipOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addExchangeProperty(option);
            }
        }
        return model;
    }

    public static PojoBeanModel generatePojoBeanModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generatePojoBeanModel(obj);
    }

    public static PojoBeanModel generatePojoBeanModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"bean");
        PojoBeanModel model = new PojoBeanModel();
        JsonMapper.parseModel(mobj, model);
        JsonMapper.parseArtifact(mobj, model);
        JsonObject mprp = (JsonObject)mobj.get((Object)"properties");
        if (mprp != null) {
            for (Map.Entry entry : mprp.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                PojoBeanModel.PojoBeanOptionModel option = new PojoBeanModel.PojoBeanOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addOption(option);
            }
        }
        return model;
    }

    public static String createParameterJsonSchema(EipModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(EipModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        obj.put((Object)"abstract", (Object)model.isAbstractModel());
        obj.put((Object)"input", (Object)model.isInput());
        obj.put((Object)"output", (Object)model.isOutput());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"model", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        if (!model.getExchangeProperties().isEmpty()) {
            wrapper.put((Object)"exchangeProperties", (Object)JsonMapper.asJsonObject(model.getExchangeProperties()));
        }
        return wrapper;
    }

    public static String createParameterJsonSchema(PojoBeanModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(PojoBeanModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"bean", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static LanguageModel generateLanguageModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateLanguageModel(obj);
    }

    public static LanguageModel generateLanguageModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"language");
        LanguageModel model = new LanguageModel();
        JsonMapper.parseModel(mobj, model);
        model.setModelName(mobj.getString("modelName"));
        model.setModelJavaType(mobj.getString("modelJavaType"));
        JsonMapper.parseArtifact(mobj, model);
        JsonObject mprp = (JsonObject)obj.get((Object)"properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            LanguageModel.LanguageOptionModel option = new LanguageModel.LanguageOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        JsonObject mprf = (JsonObject)obj.get((Object)"functions");
        if (mprf != null) {
            for (Map.Entry entry : mprf.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                LanguageModel.LanguageFunctionModel func = new LanguageModel.LanguageFunctionModel();
                JsonMapper.parseFunction(mp, func, (String)entry.getKey());
                model.addFunction(func);
            }
        }
        return model;
    }

    public static String createParameterJsonSchema(LanguageModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(LanguageModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put((Object)"modelName", (Object)model.getModelName());
        obj.put((Object)"modelJavaType", (Object)model.getModelJavaType());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"language", (Object)obj);
        wrapper.put((Object)"properties", (Object)JsonMapper.asJsonObject(model.getOptions()));
        List<LanguageModel.LanguageFunctionModel> functions = model.getFunctions();
        if (!functions.isEmpty()) {
            wrapper.put((Object)"functions", (Object)JsonMapper.asJsonObjectFunctions(functions));
        }
        return wrapper;
    }

    public static TransformerModel generateTransformerModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateTransformerModel(obj);
    }

    public static TransformerModel generateTransformerModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"transformer");
        TransformerModel model = new TransformerModel();
        JsonMapper.parseModel(mobj, model);
        model.setFrom(mobj.getString("from"));
        model.setTo(mobj.getString("to"));
        JsonMapper.parseArtifact(mobj, model);
        return model;
    }

    public static String createParameterJsonSchema(TransformerModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(TransformerModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put((Object)"from", (Object)model.getFrom());
        obj.put((Object)"to", (Object)model.getTo());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"transformer", (Object)obj);
        return wrapper;
    }

    public static DevConsoleModel generateDevConsoleModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateDevConsoleModel(obj);
    }

    public static DevConsoleModel generateDevConsoleModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"console");
        DevConsoleModel model = new DevConsoleModel();
        JsonMapper.parseModel(mobj, model);
        model.setGroup(mobj.getString("group"));
        JsonMapper.parseArtifact(mobj, model);
        return model;
    }

    public static String createParameterJsonSchema(DevConsoleModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(DevConsoleModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put((Object)"group", (Object)model.getGroup());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"console", (Object)obj);
        return wrapper;
    }

    public static OtherModel generateOtherModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateOtherModel(obj);
    }

    public static OtherModel generateOtherModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get((Object)"other");
        OtherModel model = new OtherModel();
        JsonMapper.parseModel(mobj, model);
        JsonMapper.parseArtifact(mobj, model);
        return model;
    }

    public static String createJsonSchema(OtherModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(OtherModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put((Object)"other", (Object)obj);
        return wrapper;
    }

    private static void baseToJson(BaseModel<?> model, JsonObject obj) {
        obj.put((Object)"kind", (Object)model.getKind());
        obj.put((Object)"name", (Object)model.getName());
        obj.put((Object)"title", (Object)model.getTitle());
        obj.put((Object)"description", (Object)model.getDescription());
        obj.put((Object)"deprecated", (Object)model.isDeprecated());
        obj.put((Object)"deprecatedSince", (Object)model.getDeprecatedSince());
        obj.put((Object)"deprecationNote", (Object)model.getDeprecationNote());
        obj.put((Object)"firstVersion", (Object)model.getFirstVersion());
        obj.put((Object)"label", (Object)model.getLabel());
        obj.put((Object)"javaType", (Object)model.getJavaType());
        if (model.getSupportLevel() != null) {
            obj.put((Object)"supportLevel", (Object)model.getSupportLevel().name());
        }
        if (model.isNativeSupported()) {
            obj.put((Object)"nativeSupported", (Object)model.isNativeSupported());
        }
        if (!model.getMetadata().isEmpty()) {
            obj.put((Object)"metadata", model.getMetadata());
        }
    }

    private static void artifactToJson(ArtifactModel<?> model, JsonObject obj) {
        obj.put((Object)"groupId", (Object)model.getGroupId());
        obj.put((Object)"artifactId", (Object)model.getArtifactId());
        obj.put((Object)"version", (Object)model.getVersion());
    }

    private static void parseModel(JsonObject mobj, BaseModel<?> model) {
        model.setTitle(mobj.getString("title"));
        model.setName(mobj.getString("name"));
        model.setDescription(mobj.getString("description"));
        model.setFirstVersion(mobj.getString("firstVersion"));
        model.setLabel(mobj.getString("label"));
        model.setDeprecated(mobj.getBooleanOrDefault("deprecated", false));
        model.setDeprecatedSince(mobj.getString("deprecatedSince"));
        model.setDeprecationNote(mobj.getString("deprecationNote"));
        model.setJavaType(mobj.getString("javaType"));
        model.setSupportLevel(SupportLevel.safeValueOf(mobj.getString("supportLevel")));
        model.setNativeSupported(mobj.getBooleanOrDefault("nativeSupported", false));
        model.setMetadata(mobj.getMapOrDefault("metadata", (Map)new JsonObject()));
    }

    private static void parseOption(JsonObject mp, BaseOptionModel option, String name) {
        option.setName(name);
        Integer idx = mp.getInteger("index");
        if (idx != null) {
            option.setIndex(idx);
        }
        option.setKind(mp.getString("kind"));
        option.setDisplayName(mp.getString("displayName"));
        option.setGroup(mp.getString("group"));
        option.setLabel(mp.getString("label"));
        option.setRequired(mp.getBooleanOrDefault("required", false));
        option.setType(mp.getString("type"));
        option.setJavaType(mp.getString("javaType"));
        option.setEnums(JsonMapper.asStringList(mp.getCollection("enum")));
        option.setOneOfs(JsonMapper.asStringList(mp.getCollection("oneOf")));
        option.setPrefix(mp.getString("prefix"));
        option.setOptionalPrefix(mp.getString("optionalPrefix"));
        option.setMultiValue(mp.getBooleanOrDefault("multiValue", false));
        option.setDeprecated(mp.getBooleanOrDefault("deprecated", false));
        option.setAutowired(mp.getBooleanOrDefault("autowired", false));
        option.setDeprecationNote(mp.getString("deprecationNote"));
        option.setSecret(mp.getBooleanOrDefault("secret", false));
        option.setDefaultValue(mp.get((Object)"defaultValue"));
        option.setAsPredicate(mp.getBooleanOrDefault("asPredicate", false));
        option.setConfigurationClass(mp.getString("configurationClass"));
        option.setConfigurationField(mp.getString("configurationField"));
        option.setDescription(mp.getString("description"));
        option.setGetterMethod(mp.getString("getterMethod"));
        option.setSetterMethod(mp.getString("setterMethod"));
        option.setSupportFileReference(mp.getBooleanOrDefault("supportFileReference", false));
        option.setLargeInput(mp.getBooleanOrDefault("largeInput", false));
        option.setInputLanguage(mp.getString("inputLanguage"));
    }

    private static void parseGroup(JsonObject mp, MainModel.MainGroupModel option) {
        option.setName(mp.getString("name"));
        option.setDescription(mp.getString("description"));
        option.setSourceType(mp.getString("sourceType"));
    }

    private static void parseFunction(JsonObject mp, LanguageModel.LanguageFunctionModel func, String name) {
        func.setName(name);
        func.setConstantName(name);
        Integer idx = mp.getInteger("index");
        if (idx != null) {
            func.setIndex(idx);
        }
        func.setKind(mp.getString("kind"));
        func.setDisplayName(mp.getString("displayName"));
        func.setGroup(mp.getString("group"));
        func.setLabel(mp.getString("label"));
        func.setRequired(mp.getBooleanOrDefault("required", false));
        func.setJavaType(mp.getString("javaType"));
        func.setPrefix(mp.getString("prefix"));
        func.setDeprecated(mp.getBooleanOrDefault("deprecated", false));
        func.setDeprecationNote(mp.getString("deprecationNote"));
        func.setDescription(mp.getString("description"));
        func.setOgnl(mp.getBoolean("ognl"));
        func.setSuffix(mp.getString("suffix"));
    }

    public static JsonObject asJsonObject(List<? extends BaseOptionModel> options) {
        JsonObject json = new JsonObject();
        for (int i = 0; i < options.size(); ++i) {
            BaseOptionModel o = options.get(i);
            o.setIndex(i);
            json.put((Object)o.getName(), (Object)JsonMapper.asJsonObject(o));
        }
        return json;
    }

    public static JsonObject asJsonObjectFunctions(List<LanguageModel.LanguageFunctionModel> options) {
        JsonObject json = new JsonObject();
        for (int i = 0; i < options.size(); ++i) {
            LanguageModel.LanguageFunctionModel o = options.get(i);
            o.setIndex(i);
            JsonObject jo = JsonMapper.asJsonObject(o);
            jo.put((Object)"ognl", (Object)o.isOgnl());
            if (o.getPrefix() != null) {
                jo.put((Object)"prefix", (Object)o.getPrefix());
            }
            if (o.getSuffix() != null) {
                jo.put((Object)"suffix", (Object)o.getSuffix());
            }
            json.put((Object)o.getName(), (Object)jo);
        }
        return json;
    }

    public static JsonObject apiModelAsJsonObject(Collection<ApiModel> model, boolean options) {
        JsonObject root = new JsonObject();
        model.forEach(a -> {
            JsonObject json = new JsonObject();
            root.put((Object)a.getName(), (Object)json);
            if (!options) {
                json.put((Object)"consumerOnly", (Object)a.isConsumerOnly());
                json.put((Object)"producerOnly", (Object)a.isProducerOnly());
                if (a.getDescription() != null) {
                    json.put((Object)"description", (Object)a.getDescription());
                }
                if (!a.getAliases().isEmpty()) {
                    json.put((Object)"aliases", (Object)new JsonArray(a.getAliases()));
                }
            }
            TreeMap methods = new TreeMap();
            json.put((Object)"methods", methods);
            a.getMethods().forEach(m -> {
                JsonObject mJson = new JsonObject();
                if (!options) {
                    if (m.getDescription() != null) {
                        mJson.put((Object)"description", (Object)m.getDescription());
                    }
                    if (!m.getSignatures().isEmpty()) {
                        mJson.put((Object)"signatures", (Object)new JsonArray(m.getSignatures()));
                    }
                }
                if (options) {
                    mJson.put((Object)"properties", (Object)JsonMapper.asJsonObject(m.getOptions()));
                }
                methods.put(m.getName(), mJson);
            });
        });
        return root;
    }

    public static JsonObject asJsonObject(BaseOptionModel option) {
        JsonObject prop = new JsonObject();
        prop.put((Object)"index", (Object)option.getIndex());
        prop.put((Object)"kind", (Object)option.getKind());
        prop.put((Object)"displayName", (Object)option.getDisplayName());
        prop.put((Object)"group", (Object)option.getGroup());
        prop.put((Object)"label", (Object)option.getLabel());
        prop.put((Object)"required", (Object)option.isRequired());
        prop.put((Object)"type", (Object)option.getType());
        prop.put((Object)"javaType", (Object)option.getJavaType());
        prop.put((Object)"enum", option.getEnums());
        prop.put((Object)"oneOf", option.getOneOfs());
        prop.put((Object)"prefix", (Object)option.getPrefix());
        prop.put((Object)"optionalPrefix", (Object)option.getOptionalPrefix());
        prop.put((Object)"multiValue", (Object)option.isMultiValue());
        prop.put((Object)"deprecated", (Object)option.isDeprecated());
        prop.put((Object)"deprecationNote", (Object)option.getDeprecationNote());
        prop.put((Object)"autowired", (Object)option.isAutowired());
        prop.put((Object)"secret", (Object)option.isSecret());
        prop.put((Object)"defaultValue", option.getDefaultValue());
        if (option.isSupportFileReference()) {
            prop.put((Object)"supportFileReference", (Object)option.isSupportFileReference());
        }
        if (option.isLargeInput()) {
            prop.put((Object)"largeInput", (Object)option.isLargeInput());
        }
        if (!Strings.isNullOrEmpty(option.getInputLanguage())) {
            prop.put((Object)"inputLanguage", (Object)option.getInputLanguage());
        }
        prop.put((Object)"asPredicate", (Object)option.isAsPredicate());
        prop.put((Object)"configurationClass", (Object)option.getConfigurationClass());
        prop.put((Object)"configurationField", (Object)option.getConfigurationField());
        prop.put((Object)"description", (Object)option.getDescription());
        prop.put((Object)"getterMethod", (Object)option.getGetterMethod());
        prop.put((Object)"setterMethod", (Object)option.getSetterMethod());
        if (option instanceof ComponentModel.ApiOptionModel) {
            prop.put((Object)"optional", (Object)((ComponentModel.ApiOptionModel)option).isOptional());
        } else if (option instanceof ComponentModel.EndpointHeaderModel) {
            prop.put((Object)"constantName", (Object)((ComponentModel.EndpointHeaderModel)option).getConstantName());
        }
        prop.entrySet().removeIf(e -> e.getValue() == null);
        prop.remove((Object)"prefix", (Object)"");
        prop.remove((Object)"optionalPrefix", (Object)"");
        prop.remove((Object)"defaultValue", (Object)"");
        prop.remove((Object)"multiValue", (Object)Boolean.FALSE);
        prop.remove((Object)"asPredicate", (Object)Boolean.FALSE);
        return prop;
    }

    public static MainModel generateMainModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateMainModel(obj);
    }

    public static MainModel generateMainModel(JsonObject obj) {
        MainModel model = new MainModel();
        JsonArray mgrp = (JsonArray)obj.get((Object)"groups");
        for (Object entry : mgrp) {
            JsonObject mg = (JsonObject)entry;
            MainModel.MainGroupModel group = new MainModel.MainGroupModel();
            JsonMapper.parseGroup(mg, group);
            model.addGroup(group);
        }
        JsonArray mprp = (JsonArray)obj.get((Object)"properties");
        for (Object entry : mprp) {
            JsonObject mp = (JsonObject)entry;
            MainModel.MainOptionModel option = new MainModel.MainOptionModel();
            JsonMapper.parseOption(mp, option, mp.getString("name"));
            option.setSourceType(mp.getString("sourceType"));
            model.addOption(option);
        }
        return model;
    }

    public static JsonObject asJsonObject(MainModel model) {
        JsonObject json = new JsonObject();
        JsonArray groups = new JsonArray();
        for (MainModel.MainGroupModel group : model.getGroups()) {
            JsonObject j = new JsonObject();
            j.put((Object)"name", (Object)group.getName());
            j.put((Object)"description", (Object)group.getDescription());
            j.put((Object)"sourceType", (Object)group.getSourceType());
            groups.add((Object)j);
        }
        json.put((Object)"groups", (Object)groups);
        JsonArray props = new JsonArray();
        for (MainModel.MainOptionModel prop : model.getOptions()) {
            JsonObject j = new JsonObject();
            j.put((Object)"name", (Object)prop.getName());
            j.put((Object)"description", (Object)prop.getDescription());
            j.put((Object)"sourceType", (Object)prop.getSourceType());
            j.put((Object)"type", (Object)prop.getType());
            j.put((Object)"javaType", (Object)prop.getJavaType());
            if (prop.getDefaultValue() != null) {
                j.put((Object)"defaultValue", prop.getDefaultValue());
            }
            if (prop.getEnums() != null) {
                j.put((Object)"enum", prop.getEnums());
            }
            if (prop.isDeprecated()) {
                j.put((Object)"deprecated", (Object)prop.isDeprecated());
            }
            if (prop.isAutowired()) {
                j.put((Object)"autowired", (Object)prop.isAutowired());
            }
            props.add((Object)j);
        }
        json.put((Object)"properties", (Object)props);
        return json;
    }

    public static JsonObject asJsonObject(ReleaseModel model) {
        JsonObject json = new JsonObject();
        json.put((Object)"version", (Object)model.getVersion());
        json.put((Object)"date", (Object)model.getDate());
        if (model.getEol() != null) {
            json.put((Object)"eol", (Object)model.getEol());
        }
        if (model.getKind() != null) {
            json.put((Object)"kind", (Object)model.getKind());
        }
        if (model.getJdk() != null) {
            json.put((Object)"jdk", (Object)model.getJdk());
        }
        return json;
    }

    public static ReleaseModel generateReleaseModel(JsonObject obj) {
        ReleaseModel model = new ReleaseModel();
        model.setVersion(obj.getString("version"));
        model.setDate(obj.getString("date"));
        model.setEol(obj.getString("eol"));
        model.setKind(obj.getString("kind"));
        model.setJdk(obj.getString("jdk"));
        return model;
    }

    public static String createJsonSchema(MainModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject deserialize(String json) {
        try {
            return (JsonObject)Jsoner.deserialize((String)json);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse json", e);
        }
    }

    public static String serialize(Object json) {
        return Jsoner.prettyPrint((String)Jsoner.serialize((Object)json), (int)2, (int)2);
    }

    protected static List<String> asStringList(Collection<?> col) {
        if (col != null) {
            return col.stream().map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }
}

