/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import org.apache.camel.test.spring.CamelAnnotationsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class CamelSpringBootExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootExecutionListener.class);

    public void prepareTestInstance(TestContext testContext) throws Exception {
        LOG.info("@RunWith(CamelSpringBootJUnit4ClassRunner.class) preparing: {}", (Object)testContext.getTestClass());
        Class testClass = testContext.getTestClass();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)testContext.getApplicationContext();
        CamelAnnotationsHandler.handleProvidesBreakpoint(context, testClass);
        CamelAnnotationsHandler.handleShutdownTimeout(context, testClass);
        CamelAnnotationsHandler.handleMockEndpoints(context, testClass);
        CamelAnnotationsHandler.handleMockEndpointsAndSkip(context, testClass);
        CamelAnnotationsHandler.handleUseOverridePropertiesWithPropertiesComponent(context, testClass);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        LOG.info("@RunWith(CamelSpringBootJUnit4ClassRunner.class) before: {}.{}", (Object)testContext.getTestClass(), (Object)testContext.getTestMethod().getName());
        Class testClass = testContext.getTestClass();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)testContext.getApplicationContext();
        System.clearProperty("skipStartingCamelContext");
        LOG.info("Initialized CamelSpringBootJUnit4ClassRunner now ready to start CamelContext");
        CamelAnnotationsHandler.handleCamelContextStartup(context, testClass);
    }
}

