/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.test.spring.junit5.RouteCoverageDumper;

public class RouteCoverageEventNotifier
extends EventNotifierSupport {
    private final String testClassName;
    private final Function testMethodName;

    public RouteCoverageEventNotifier(String testClassName, Function testMethodName) {
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
        this.setIgnoreCamelContextEvents(false);
        this.setIgnoreExchangeEvents(true);
    }

    public boolean isEnabled(CamelEvent event) {
        return event instanceof CamelEvent.CamelContextStoppingEvent;
    }

    public void notify(CamelEvent event) throws Exception {
        CamelContext context = ((CamelEvent.CamelContextStoppingEvent)event).getContext();
        String testName = (String)this.testMethodName.apply(this);
        RouteCoverageDumper.dumpRouteCoverage(context, this.testClassName, testName);
    }
}

