/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.test.junit5.CamelContextConfiguration;
import org.apache.camel.test.junit5.CamelContextManager;
import org.apache.camel.test.junit5.JunitPropertiesSource;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.test.junit5.util.CamelContextTestHelper;
import org.apache.camel.test.junit5.util.ExtensionHelper;
import org.apache.camel.test.junit5.util.RouteCoverageDumperExtension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyCamelContextManager
implements CamelContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyCamelContextManager.class);
    private static final ThreadLocal<LegacyCamelContextManager> INSTANCE = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> TESTS = new ThreadLocal();
    private static final ThreadLocal<ModelCamelContext> THREAD_CAMEL_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<ProducerTemplate> THREAD_TEMPLATE = new ThreadLocal();
    private static final ThreadLocal<FluentProducerTemplate> THREAD_FLUENT_TEMPLATE = new ThreadLocal();
    private static final ThreadLocal<ConsumerTemplate> THREAD_CONSUMER = new ThreadLocal();
    private static final ThreadLocal<Service> THREAD_SERVICE = new ThreadLocal();
    private final TestExecutionConfiguration testConfigurationBuilder;
    private final CamelContextConfiguration camelContextConfiguration;
    private ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile FluentProducerTemplate fluentTemplate;
    protected volatile ConsumerTemplate consumer;
    private Properties extra;
    private ExtensionContext.Store globalStore;

    public LegacyCamelContextManager(TestExecutionConfiguration testConfigurationBuilder, CamelContextConfiguration camelContextConfiguration) {
        this.testConfigurationBuilder = testConfigurationBuilder;
        this.camelContextConfiguration = camelContextConfiguration;
        Service service = camelContextConfiguration.camelContextService();
        if (service != null) {
            THREAD_SERVICE.set(service);
        }
    }

    @Override
    public void createCamelContext(Object test) throws Exception {
        if (this.testConfigurationBuilder.isCreateCamelContextPerClass()) {
            this.createCamelContextPerClass(test);
        } else {
            this.initialize(test);
        }
    }

    @Override
    public void beforeContextStart(Object test) throws Exception {
        this.context = THREAD_CAMEL_CONTEXT.get();
        this.template = THREAD_TEMPLATE.get();
        this.fluentTemplate = THREAD_FLUENT_TEMPLATE.get();
        this.consumer = THREAD_CONSUMER.get();
        this.applyCamelPostProcessor(test);
        this.camelContextConfiguration.postProcessor().postSetup();
    }

    private void createCamelContextPerClass(Object test) throws Exception {
        INSTANCE.set(this);
        AtomicInteger v = TESTS.get();
        if (v == null) {
            v = new AtomicInteger();
            TESTS.set(v);
        }
        if (v.getAndIncrement() == 0) {
            LOG.debug("Setup CamelContext before running first test");
            this.initialize(test);
        } else {
            LOG.debug("Reset between test methods");
            this.beforeContextStart(test);
            MockEndpoint.resetMocks((CamelContext)this.context);
        }
    }

    private void initialize(Object test) throws Exception {
        if (this.context != null) {
            return;
        }
        this.doCreateContext(test);
        this.camelContextConfiguration.registryBinder().bindToRegistry(this.context.getRegistry());
        this.context.getShutdownStrategy().setTimeout((long)this.camelContextConfiguration.shutdownTimeout());
        if (this.camelContextConfiguration.useDebugger()) {
            CamelContextTestHelper.setupDebugger((CamelContext)this.context, this.camelContextConfiguration.breakpoint());
        }
        this.setupTemplates();
        String mockPattern = this.camelContextConfiguration.mockEndpoints();
        String mockAndSkipPattern = this.camelContextConfiguration.mockEndpointsAndSkip();
        CamelContextTestHelper.enableAutoMocking((CamelContext)this.context, mockPattern, mockAndSkipPattern);
        this.configurePropertiesComponent();
        this.configureIncludeExcludePatterns();
        this.beforeContextStart(test);
        if (this.testConfigurationBuilder.useRouteBuilder()) {
            this.setupRoutes();
            this.tryStartCamelContext();
        } else {
            CamelContextTestHelper.replaceFromEndpoints(this.context, this.camelContextConfiguration.fromEndpoints());
            LOG.debug("Using route builder from the created context: {}", (Object)this.context);
        }
        LOG.debug("Routing Rules are: {}", (Object)this.context.getRoutes());
    }

    private void doCreateContext(Object test) throws Exception {
        LOG.debug("Initializing a new CamelContext");
        if (this.testConfigurationBuilder.isJmxEnabled() || this.testConfigurationBuilder.isRouteCoverageEnabled() || TestSupport.isCamelDebugPresent()) {
            this.enableJMX();
        } else {
            this.disableJMX();
        }
        this.context = (ModelCamelContext)this.camelContextConfiguration.camelContextSupplier().createCamelContext();
        assert (this.context != null) : "No context found!";
        THREAD_CAMEL_CONTEXT.set(this.context);
        Method setContextMethod = test.getClass().getMethod("setContext", ModelCamelContext.class);
        setContextMethod.invoke(test, this.context);
    }

    private void setupTemplates() {
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.fluentTemplate = this.context.createFluentProducerTemplate();
        this.fluentTemplate.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
        THREAD_TEMPLATE.set(this.template);
        THREAD_FLUENT_TEMPLATE.set(this.fluentTemplate);
        THREAD_CONSUMER.set(this.consumer);
    }

    private void configureIncludeExcludePatterns() {
        String include = this.camelContextConfiguration.routeFilterIncludePattern();
        String exclude = this.camelContextConfiguration.routeFilterExcludePattern();
        CamelContextTestHelper.configureIncludeExcludePatterns((CamelContext)this.context, include, exclude);
    }

    private void configurePropertiesComponent() {
        if (this.extra == null) {
            this.extra = this.camelContextConfiguration.useOverridePropertiesWithPropertiesComponent();
        }
        Boolean ignore = this.camelContextConfiguration.ignoreMissingLocationWithPropertiesComponent();
        CamelContextTestHelper.configurePropertiesComponent((CamelContext)this.context, this.extra, new JunitPropertiesSource(this.globalStore), ignore);
    }

    private void setupRoutes() throws Exception {
        RoutesBuilder[] builders = this.camelContextConfiguration.routesSupplier().createRouteBuilders();
        CamelContextTestHelper.setupRoutes((CamelContext)this.context, builders);
        CamelContextTestHelper.replaceFromEndpoints(this.context, this.camelContextConfiguration.fromEndpoints());
    }

    private void tryStartCamelContext() throws Exception {
        boolean skip = CamelContextTestHelper.isSkipAutoStartContext(this.testConfigurationBuilder);
        if (skip) {
            LOG.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true or auto start context is false.");
        } else if (this.testConfigurationBuilder.isUseAdviceWith()) {
            LOG.info("Skipping starting CamelContext as isUseAdviceWith is set to true.");
        } else {
            CamelContextTestHelper.startCamelContextOrService((CamelContext)this.context, this.camelContextConfiguration.camelContextService());
        }
    }

    protected void disableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)true);
    }

    protected void enableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)false);
    }

    @Override
    public ModelCamelContext context() {
        return this.context;
    }

    @Override
    public ProducerTemplate template() {
        return this.template;
    }

    @Override
    public FluentProducerTemplate fluentTemplate() {
        return this.fluentTemplate;
    }

    @Override
    public ConsumerTemplate consumer() {
        return this.consumer;
    }

    @Override
    public Service camelContextService() {
        return THREAD_SERVICE.get();
    }

    @Override
    public void startCamelContext() throws Exception {
        CamelContextTestHelper.startCamelContextOrService((CamelContext)this.context, this.camelContextConfiguration.camelContextService());
    }

    @Override
    public void stopCamelContext() {
        this.doStopCamelContext((CamelContext)this.context, this.camelContextConfiguration.camelContextService());
    }

    @Override
    public void stop() {
    }

    @Override
    public void close() {
        LegacyCamelContextManager support = INSTANCE.get();
        if (support != null && this.testConfigurationBuilder.isCreateCamelContextPerClass()) {
            try {
                support.tearDownCreateCamelContextPerClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.doStopCamelContext((CamelContext)THREAD_CAMEL_CONTEXT.get(), THREAD_SERVICE.get());
    }

    @Override
    public void stopTemplates() {
        LegacyCamelContextManager.doStopTemplates(THREAD_CONSUMER.get(), THREAD_TEMPLATE.get(), THREAD_FLUENT_TEMPLATE.get());
    }

    void tearDownCreateCamelContextPerClass() {
        LOG.debug("tearDownCreateCamelContextPerClass()");
        TESTS.remove();
        this.stopTemplates();
        this.doStopCamelContext((CamelContext)THREAD_CAMEL_CONTEXT.get(), THREAD_SERVICE.get());
    }

    private static void doStopTemplates(ConsumerTemplate consumer, ProducerTemplate template, FluentProducerTemplate fluentTemplate) {
        if (consumer != null) {
            if (consumer == THREAD_CONSUMER.get()) {
                THREAD_CONSUMER.remove();
            }
            consumer.stop();
        }
        if (template != null) {
            if (template == THREAD_TEMPLATE.get()) {
                THREAD_TEMPLATE.remove();
            }
            template.stop();
        }
        if (fluentTemplate != null) {
            if (fluentTemplate == THREAD_FLUENT_TEMPLATE.get()) {
                THREAD_FLUENT_TEMPLATE.remove();
            }
            fluentTemplate.stop();
        }
    }

    protected void doStopCamelContext(CamelContext context, Service camelContextService) {
        if (camelContextService != null) {
            if (camelContextService == THREAD_SERVICE.get()) {
                THREAD_SERVICE.remove();
            }
            camelContextService.stop();
        } else if (context != null) {
            if (context == THREAD_CAMEL_CONTEXT.get()) {
                THREAD_CAMEL_CONTEXT.remove();
            }
            context.stop();
        }
    }

    protected void applyCamelPostProcessor(Object test) throws Exception {
        boolean spring = ExtensionHelper.hasClassAnnotation(test.getClass(), "org.springframework.context.annotation.ComponentScan");
        if (!spring) {
            PluginHelper.getBeanPostProcessor((CamelContext)this.context).postProcessBeforeInitialization(test, test.getClass().getName());
            PluginHelper.getBeanPostProcessor((CamelContext)this.context).postProcessAfterInitialization(test, test.getClass().getName());
        }
    }

    @Override
    public void setGlobalStore(ExtensionContext.Store globalStore) {
        this.globalStore = globalStore;
    }

    @Override
    public void dumpRouteCoverage(Class<?> clazz, String currentTestName, long time) throws Exception {
        if (this.testConfigurationBuilder.isRouteCoverageEnabled()) {
            RouteCoverageDumperExtension routeCoverageWrapper = new RouteCoverageDumperExtension(this.context);
            routeCoverageWrapper.dumpRouteCoverage(clazz, currentTestName, time);
        }
    }
}

