/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5.util;

import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.test.junit5.util.RouteCoverageDumperExtension;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionHelper.class);
    public static final String SEPARATOR = "*".repeat(80);
    private static final String SPRING_BOOT_TEST = "org.springframework.boot.test.context.SpringBootTest";
    private static final String QUARKUS_TEST = "io.quarkus.test.junit.QuarkusTest";
    private static final String CAMEL_QUARKUS_TEST = "org.apache.camel.quarkus.test.CamelQuarkusTest";

    private static void throwUnsupportedClassException(String name) {
        switch (name) {
            case "org.springframework.boot.test.context.SpringBootTest": {
                throw new RuntimeException("Spring Boot detected: The CamelTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Spring Boot.");
            }
            case "io.quarkus.test.junit.QuarkusTest": 
            case "org.apache.camel.quarkus.test.CamelQuarkusTest": {
                throw new RuntimeException("Quarkus detected: The CamelTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Quarkus.");
            }
        }
        throw new RuntimeException("Unspecified class detected: The " + name + " class is not intended for Camel testing");
    }

    public static boolean hasUnsupported(Class<?> clazz) {
        ExtensionHelper.hasClassAnnotation(clazz, ExtensionHelper::throwUnsupportedClassException, SPRING_BOOT_TEST, QUARKUS_TEST, CAMEL_QUARKUS_TEST);
        return true;
    }

    public static void hasClassAnnotation(Class<?> clazz, Consumer<String> classConsumer, String ... names) {
        for (String name : names) {
            for (Annotation ann : clazz.getAnnotations()) {
                String annName = ann.annotationType().getName();
                if (!annName.equals(name)) continue;
                classConsumer.accept(name);
            }
        }
    }

    public static boolean hasClassAnnotation(Class<?> clazz, String ... names) {
        for (String name : names) {
            for (Annotation ann : clazz.getAnnotations()) {
                String annName = ann.annotationType().getName();
                if (!annName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static void testStartHeader(Class<?> testClass, String currentTestName) {
        LOG.info(SEPARATOR);
        LOG.info("Testing: {} ({})", (Object)currentTestName, (Object)testClass.getName());
        LOG.info(SEPARATOR);
    }

    public static void testEndFooter(Class<?> testClass, String currentTestName, long time) {
        LOG.info(SEPARATOR);
        LOG.info("Testing done: {} ({})", (Object)currentTestName, (Object)testClass.getName());
        LOG.info("Took: {} ({} millis)", (Object)TimeUtils.printDuration((long)time, (boolean)true), (Object)time);
        LOG.info(SEPARATOR);
    }

    public static void testEndFooter(Class<?> testClass, String currentTestName, long time, RouteCoverageDumperExtension routeCoverageWrapper) throws Exception {
        LOG.info(SEPARATOR);
        LOG.info("Testing done: {} ({})", (Object)currentTestName, (Object)testClass.getName());
        LOG.info("Took: {} ({} millis)", (Object)TimeUtils.printDuration((long)time, (boolean)true), (Object)time);
        if (routeCoverageWrapper != null) {
            routeCoverageWrapper.dumpRouteCoverage(testClass, currentTestName, time);
        }
        LOG.info(SEPARATOR);
    }

    public static String normalizeUri(String uri) {
        String n;
        try {
            n = URISupport.normalizeUri((String)uri);
        }
        catch (URISyntaxException e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        return n;
    }
}

