/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5.util;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.TestExecutionConfiguration;
import org.apache.camel.test.junit5.TestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelContextTestHelper {
    public static final String ROUTE_COVERAGE_ENABLED = "CamelTestRouteCoverage";
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextTestHelper.class);

    public static CamelContext createCamelContext(Registry registry) throws Exception {
        DefaultCamelContext retContext = registry != null ? new DefaultCamelContext(registry) : new DefaultCamelContext();
        return retContext;
    }

    public static void setupDebugger(CamelContext context, Breakpoint breakpoint) {
        assert (context != null) : "You cannot set a debugger on a null context";
        assert (breakpoint != null) : "You cannot set a debugger using a null debug breakpoint";
        if (context.getStatus().equals((Object)ServiceStatus.Started)) {
            LOG.info("Cannot setting the Debugger to the starting CamelContext, stop the CamelContext now.");
            context.stop();
        }
        context.setDebugging(Boolean.valueOf(true));
        DefaultDebugger defaultDebugger = new DefaultDebugger();
        context.setDebugger((Debugger)defaultDebugger);
        defaultDebugger.addBreakpoint(breakpoint);
    }

    public static void setupRoutes(CamelContext context, RoutesBuilder[] builders) throws Exception {
        for (RoutesBuilder builder : builders) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            LOG.debug("Using created route configuration: {}", (Object)builder);
            context.addRoutesConfigurations((RouteConfigurationsBuilder)builder);
        }
        for (RoutesBuilder builder : builders) {
            LOG.debug("Using created route builder to add routes: {}", (Object)builder);
            context.addRoutes(builder);
        }
        for (RoutesBuilder builder : builders) {
            LOG.debug("Using created route builder to add templated routes: {}", (Object)builder);
            context.addTemplatedRoutes(builder);
        }
    }

    public static MockEndpoint lookupEndpoint(CamelContext context, String uri, boolean create, String target) {
        MockEndpoint found = context.getEndpointRegistry().values().stream().filter(e -> e instanceof MockEndpoint).filter(e -> {
            String t = e.getEndpointUri();
            int idx2 = t.indexOf(63);
            if (idx2 != -1) {
                t = t.substring(0, idx2);
            }
            return t.equals(target);
        }).findFirst().orElse(null);
        if (found != null) {
            return found;
        }
        if (create) {
            return TestSupport.resolveMandatoryEndpoint(context, uri, MockEndpoint.class);
        }
        throw new NoSuchEndpointException(String.format("MockEndpoint %s does not exist.", uri));
    }

    public static void enableAutoMocking(CamelContext context, String pattern, String mockAndSkipPattern) {
        if (pattern != null) {
            context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        if (mockAndSkipPattern != null) {
            context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockAndSkipPattern, true));
        }
    }

    public static void configurePropertiesComponent(CamelContext context, Properties extra, PropertiesSource propertiesSource, Boolean ignore) {
        PropertiesComponent pc = context.getPropertiesComponent();
        if (extra != null && !extra.isEmpty()) {
            pc.setOverrideProperties(extra);
        }
        pc.addPropertiesSource(propertiesSource);
        if (ignore != null) {
            pc.setIgnoreMissingLocation(ignore.booleanValue());
        }
    }

    public static void configureIncludeExcludePatterns(CamelContext context, String include, String exclude) {
        if (include != null || exclude != null) {
            LOG.info("Route filtering pattern: include={}, exclude={}", (Object)include, (Object)exclude);
            ((Model)context.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern(include, exclude);
        }
    }

    public static void startCamelContext(CamelContext context) throws Exception {
        if (context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            context.start();
        }
    }

    public static void startCamelContextOrService(CamelContext context, Service camelContextService) throws Exception {
        if (camelContextService != null) {
            camelContextService.start();
        } else {
            CamelContextTestHelper.startCamelContext(context);
        }
    }

    public static void replaceFromEndpoints(ModelCamelContext context, Map<String, String> fromEndpoints) throws Exception {
        for (final Map.Entry<String, String> entry : fromEndpoints.entrySet()) {
            AdviceWith.adviceWith((RouteDefinition)context.getRouteDefinition(entry.getKey()), (CamelContext)context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() {
                    this.replaceFromWith((String)entry.getValue());
                }
            });
        }
    }

    public static boolean isSkipAutoStartContext(TestExecutionConfiguration configuration) {
        return Boolean.parseBoolean(System.getProperty("skipStartingCamelContext")) || !configuration.autoStartContext();
    }

    public static boolean isRouteCoverageEnabled(boolean legacyDumpCoverage) {
        return Boolean.parseBoolean(System.getProperty(ROUTE_COVERAGE_ENABLED, "false")) || legacyDumpCoverage;
    }
}

