/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.qdrant.services;

import java.util.function.Consumer;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.qdrant.services.QdrantInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.qdrant.QdrantContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=QdrantInfraService.class, description="Vector Database and Vector Search Engine", serviceAlias={"qdrant"})
public class QdrantLocalContainerInfraService
implements QdrantInfraService,
ContainerService<QdrantContainer> {
    public static final int HTTP_PORT = 6333;
    public static final int GRPC_PORT = 6334;
    private static final Logger LOG = LoggerFactory.getLogger(QdrantLocalContainerInfraService.class);
    private final QdrantContainer container;

    public QdrantLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(QdrantLocalContainerInfraService.class, (String)"qdrant.container"));
    }

    public QdrantLocalContainerInfraService(String imageName) {
        this(new QdrantContainer(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("qdrant/qdrant")));
    }

    public QdrantLocalContainerInfraService(QdrantContainer container) {
        this.container = container;
    }

    public void registerProperties() {
        System.setProperty("qdrant.http.host", this.getHttpHost());
        System.setProperty("qdrant.http.port", String.valueOf(this.getHttpPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Qdrant container");
        this.container.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(QdrantContainer.class)));
        this.container.start();
        this.registerProperties();
        LOG.info("Qdrant instance running at {}:{}", (Object)this.getHttpHost(), (Object)this.getHttpPort());
    }

    public void shutdown() {
        LOG.info("Stopping the Qdrant container");
        this.container.stop();
    }

    public QdrantContainer getContainer() {
        return this.container;
    }

    @Override
    public String getHttpHost() {
        return this.container.getHost();
    }

    @Override
    public int getHttpPort() {
        return this.container.getMappedPort(6333);
    }

    @Override
    public String getGrpcHost() {
        return this.container.getHost();
    }

    @Override
    public int getGrpcPort() {
        return this.container.getMappedPort(6334);
    }
}

