/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.postgres.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.postgres.services.PostgresService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PostgreSQLContainer;

public class PostgresLocalContainerService
implements PostgresService,
ContainerService<PostgreSQLContainer> {
    public static final String DEFAULT_POSTGRES_CONTAINER = LocalPropertyResolver.getProperty(PostgresLocalContainerService.class, (String)"postgres.container");
    private static final Logger LOG = LoggerFactory.getLogger(PostgresLocalContainerService.class);
    private final PostgreSQLContainer container;

    public PostgresLocalContainerService() {
        this(DEFAULT_POSTGRES_CONTAINER);
    }

    public PostgresLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public PostgresLocalContainerService(PostgreSQLContainer container) {
        this.container = container;
    }

    protected PostgreSQLContainer initContainer(String imageName) {
        return new PostgreSQLContainer(imageName);
    }

    public void registerProperties() {
        System.setProperty("postgres.service.address", this.getServiceAddress());
        System.setProperty("postgres.service.host", this.host());
        System.setProperty("postgres.service.port", String.valueOf(this.port()));
        System.setProperty("postgres.user.name", this.container.getUsername());
        System.setProperty("postgres.user.password", this.container.getPassword());
    }

    public void initialize() {
        LOG.info("Trying to start the Postgres container");
        this.container.start();
        this.registerProperties();
        LOG.info("Postgres instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Postgres container");
        this.container.stop();
    }

    public PostgreSQLContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue());
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%d", this.host(), this.port());
    }

    @Override
    public String userName() {
        return this.container.getUsername();
    }

    @Override
    public String password() {
        return this.container.getPassword();
    }
}

