/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.pinecone.services;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.pinecone.services.PineconeInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.pinecone.PineconeLocalContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=PineconeInfraService.class, description="Pinecone Vector Database", serviceAlias={"pinecone"})
public class PineconeLocalContainerInfraService
implements PineconeInfraService,
ContainerService<PineconeLocalContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PineconeLocalContainerInfraService.class);
    private final PineconeLocalContainer container;

    public PineconeLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(PineconeLocalContainerInfraService.class, (String)"pinecone.container"));
    }

    public PineconeLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public PineconeLocalContainerInfraService(PineconeLocalContainer container) {
        this.container = container;
    }

    protected PineconeLocalContainer initContainer(final String imageName) {
        class TestInfraPineconeLocalContainer
        extends PineconeLocalContainer {
            public TestInfraPineconeLocalContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string).asCompatibleSubstituteFor("pinecone-io/pinecone-local"));
                this.withStartupTimeout(Duration.ofMinutes(3L));
                if (fixedPort) {
                    this.addFixedExposedPort(5080, 5080);
                }
            }
        }
        return new TestInfraPineconeLocalContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("pinecone.endpoint.url", this.getPineconeEndpointUrl());
        System.setProperty("pinecone.endpoint.host", this.getPineconeHost());
        System.setProperty("pinecone.endpoint.port", String.valueOf(this.getPineconePort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Pinecone container");
        this.container.start();
        this.registerProperties();
        LOG.info("Pinecone instance running at {}", (Object)this.getPineconeEndpointUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Pinecone container");
        this.container.stop();
    }

    public PineconeLocalContainer getContainer() {
        return this.container;
    }

    @Override
    public String getPineconeEndpointUrl() {
        return this.container.getEndpoint();
    }

    @Override
    public String getPineconeHost() {
        URL url = null;
        try {
            url = URI.create(this.container.getEndpoint()).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url.getHost();
    }

    @Override
    public int getPineconePort() {
        URL url = null;
        try {
            url = URI.create(this.container.getEndpoint()).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url.getPort();
    }
}

