/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.pinecone.services;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class PineconeIndexContainer
extends GenericContainer<PineconeIndexContainer> {
    public static final String CONTAINER_NAME = "pinecone-index";
    public static final int CLIENT_PORT = 5080;
    private static final Logger LOGGER = LoggerFactory.getLogger(PineconeIndexContainer.class);
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"ghcr.io/pinecone-io/pinecone-index");

    public PineconeIndexContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public PineconeIndexContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withEnv("PINECONE_HOST", "localhost");
        this.withEnv("VECTOR_TYPE", "dense");
        this.withEnv("DIMENSION", "6");
        this.withEnv("INDEX_TYPE", "serverless");
        this.withEnv("METRIC", "cosine");
        this.withEnv("PORT", String.valueOf(5080));
        this.withExposedPorts(new Integer[]{5080});
    }

    public String getEndpoint() {
        return "http://" + this.getConnectionString();
    }

    public String getConnectionString() {
        return String.format("%s:%d", this.getHost(), this.getMappedPort(5080));
    }
}

