/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.mongodb.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.mongodb.services.MongoDBService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MongoDBLocalContainerService
implements MongoDBService,
ContainerService<MongoDBContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBLocalContainerService.class);
    private static final int DEFAULT_MONGODB_PORT = 27017;
    private final MongoDBContainer container;

    public MongoDBLocalContainerService() {
        this(LocalPropertyResolver.getProperty(MongoDBLocalContainerService.class, (String)"mongodb.container"));
    }

    public MongoDBLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public MongoDBLocalContainerService(MongoDBContainer container) {
        this.container = container;
    }

    protected MongoDBContainer initContainer(String imageName) {
        if (imageName == null || imageName.isEmpty()) {
            return new MongoDBContainer();
        }
        return new MongoDBContainer(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("mongo"));
    }

    @Override
    public String getReplicaSetUrl() {
        return String.format("mongodb://%s:%s", this.container.getHost(), this.container.getMappedPort(27017));
    }

    @Override
    public String getConnectionAddress() {
        return this.container.getHost() + ":" + this.container.getMappedPort(27017);
    }

    public void registerProperties() {
        System.setProperty("mongodb.url", this.getReplicaSetUrl());
        System.setProperty("mongodb.connection.address", this.getConnectionAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the MongoDB service");
        this.container.start();
        this.registerProperties();
        LOG.info("MongoDB service running at {}", (Object)this.container.getReplicaSetUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the MongoDB container");
        this.container.stop();
    }

    public MongoDBContainer getContainer() {
        return this.container;
    }
}

